# rule.tcl --
#
#       Wrapper for creating rules whose enable state is associated with a
#       checkbutton for use in the BD file
#
# Copyright (c) 2001-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Import enable

namespace eval BroadcastDescription_Rule {
    # onOff is an array; this is needed since checkbuttons must be associated
    #   with global variables, and there is no way to use a class instance
    #   variable
    variable onOff
}

Class BroadcastDescription_Rule

BroadcastDescription_Rule instproc init {base description check cmd {transitionOnly 1}} {
    $self instvar id_

    set id_ [BroadcastDescription_when $check $cmd $transitionOnly]
    # the rule is off by default
    set BroadcastDescription_Rule::onOff($id_) 0

    if {$base != ""} {
	set base $base.checkFrame{$self}
	frame $base -borderwidth 1 -relief solid
	pack $base -side top -fill x -pady 2 -padx 2

	# create a checkbutton widget to enable/disable it
	set widg $base.checkbutton
	checkbutton $widg -variable BroadcastDescription_Rule::onOff($id_) -command "BroadcastDescription_Rule::handleRulesCheckbox $self" -text $description -justify left
	pack $widg -side left
    }


}

BroadcastDescription_Rule instproc enable {} {
    $self instvar id_

    set BroadcastDescription_Rule::onOff($id_) 1
    BroadcastDescription_enableRule $id_ 1
}

BroadcastDescription_Rule instproc disable {} {
    $self instvar id_

    set BroadcastDescription_Rule::onOff($id_) 0
    BroadcastDescription_enableRule $id_ 0
}

BroadcastDescription_Rule instproc handleCheckbox {} {
    $self instvar id_

    if {$BroadcastDescription_Rule::onOff($id_)} {
	$self enable
    } else {
	$self disable
    }
}

proc BroadcastDescription_Rule::handleRulesCheckbox {ptr} {
    $ptr handleCheckbox
}
