# agent-sdgw.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/sdgw/agent-sdgw.tcl,v 1.27 2002/02/03 04:29:44 lim Exp $

import AnnounceListenManager/AS/Service/MeGa SDPParser AddressBlock \
	AnnounceListenManager/AS/Client/MeGa NetworkManager

Class SDGWAgent -superclass Reflector

SDGWAgent instproc init { } {
	$self next 1024

	$self instvar sessions_
	set sessions_ ""

	set megaspec [$self resource asCtrl]
	set bw [$self resource asCtrlBW]
	set sspec [$self resource megaSession]
	$self instvar gwal_ cliental_
	if { $sspec != "" } {
		set gwal_ [new AnnounceListenManager/AS/Service/MeGa $self \
				$megaspec $bw $sspec sdgw sdp]
	}
	set megaclient [$self get_option megaClient]
	if { $megaclient != "" } {
		set localbw [$self get_option localSessionBW]
		if { $localbw == "" } {
			set localbw [$self get_option maxSessionBW]
		}
		set sname [$self get_option megaSession]
		set sspec [$self get_option sessionSpec]
		set rportspec [$self get_option megaRecvPort]
		set ofmt [$self get_option megaFormat]

		set bw [expr 0.02*$localbw]
		set cliental_ [new AnnounceListenManager/AS/Client/MeGa
			      	$self $megaclient $bw sdgw sdp \
				$sname $sspec $rportspec $ofmt]
	}
	$self set sdp_ [new SDPParser]
	$self instvar checkInt_
	$self set checkInt_ [$self get_option startupIdleTime]
	after $checkInt_ "$self check_active 1"
	$self init_network

	if [info exists cliental_] {
		$cliental_ start
	}
	if [info exists gwal_] {
#		$gwal_ start 1
#puts "[gettimeofday ascii] SDGW announce"
		$gwal_ announce [$gwal_ send_announcement]
	}
}

SDGWAgent instproc destroy {} {
	$self instvar gwal_ cliental_
	delete $gwal_
	if [info exists cliental_] {
		delete $cliental_
	}
	foreach s $sessions_ {
		delete $s
	}

	$self next
}

SDGWAgent instproc set_maxchannel n {
}

SDGWAgent instproc reset_spec { spec } {
	$self instvar sessbyname_
	set ab [new AddressBlock/Simple $spec]
	$sessbyname_(global) reset $ab
	delete $ab
}


SDGWAgent instproc add_session { sname spec } {
	$self instvar sessbyname_ sessions_
	set s [new Session/SDGW $self]

	if { $spec != "none" } {
		set ab [new AddressBlock/Simple $spec]
		$s reset $ab
		delete $ab
	}

	set sessbyname_($sname) $s
	$s set sname_ $sname
	lappend sessions_ $s
}

SDGWAgent instproc init_network {} {
	$self add_session global [$self get_option defaultGlobalSpec]
	$self add_session local [$self get_option defaultLocalSpec]
}

SDGWAgent instproc have_network {} {
	$self instvar sessbyname_
	set nm [$sessbyname_(global) set netmgr_]
	if { $nm == "" } {
		return 0
	} else {
		return 1
	}
}

SDGWAgent instproc mega_register { args } {}

SDGWAgent instproc mega_unregister { atype aspec addr srv_name srv_inst } {
	if { $atype != "client" } {
		return
	}
	$self check_active 0
}

SDGWAgent instproc check_active { timer } {
	$self instvar sessbyname_ gwal_ sdp_ checkInt_

	# Check if there exists a client that is listening on our address.
	# If so, we are "active".

	set clist [$gwal_ set agentbytype_(client)]
	set s $sessbyname_(local)
	set nm [$s set netmgr_]
	if { $nm == "" } {
		if $timer {
			after $checkInt_ "$self check_active 1"
		}
	}
	set net [$nm set net_(0)]
	set dn [$net data-net]
	if [in_multicast [$dn addr]] {
		set lspec [$dn addr]/[$dn rport]:[$dn sport]/[$dn ttl]
	} else {
		set lspec [localaddr]/[$dn rport]:[$dn sport]/[$dn ttl]
	}
	foreach c $clist {
		set msg [$sdp_ parse [lindex [$gwal_ agenttab $c] 1]]
		set media [lindex [$msg set allmedia_] 0]
		set addr [lindex [$media field_value c] 2]
		delete $msg
		if { $addr == $lspec } {
			# puts "sdgw alive!"
			if $timer {
				after $checkInt_ "$self check_active 1"
			}
			return

		}
	}
        puts "sdgw: no clients, exiting."
	exit 0
}

SDGWAgent instproc network {} {
	if ![$self have_network] {
		return none
	}
	$self instvar sessbyname_
	set network [$sessbyname_(global) set netmgr_]
	return [$network data-net 0]
}

SDGWAgent instproc session-addr {} {
	if ![$self have_network] {
		return none
	}
	return [[$self network] addr]
}

SDGWAgent instproc session-port {} {
	if ![$self have_network] {
		return none
	}
	return [[$self network] port]
}

SDGWAgent instproc session-rport {} {
	if ![$self have_network] {
		return none
	}
	return [[$self network] rport]
}

SDGWAgent instproc session-sport {} {
	if ![$self have_network] {
		return none
	}
	return [[$self network] sport]
}

SDGWAgent instproc session-ttl {} {
	if ![$self have_network] {
		return none
	}
	return [[$self network] ttl]
}

Class Session/SDGW

Session/SDGW instproc init { agent } {
	$self next
	$self instvar agent_ ofmt_ netmgr_
	set agent_ $agent
	set ofmt_ null
	set netmgr_ ""
}

Session/SDGW instproc destroy {} {
	$self instvar netmgr_
	if { $netmgr_ != "" } {
		delete $netmgr_
	}
}

Session/SDGW instproc data-net { net n } {
	$self instvar agent_
	$agent_ add-network $net
}

Session/SDGW instproc ctrl-net { net n } {
}

Session/SDGW instproc data-port p {
	return $p
}

Session/SDGW instproc ctrl-port p {
	return $p
}

Session/SDGW instproc reset { ab } {
	$self instvar agent_
	set nm [new NetworkManager $ab $self $agent_]

	# Turn on loopback since multiple gateways could be running on same
	# host.
	set net [$nm set net_(0)]
	set net [$net data-net]
	$net loopback 1

	$self instvar netmgr_
	if { $netmgr_ != "" } {
		delete $netmgr_
	}
	set netmgr_ $nm
}

