# application-sdfor.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


import Application ScopeZone SAPForwarder \
    ProgramCache ProgramSource ProgramSource/SAP \
    ERSServer/Sdfor TCP/Server SdforServer ErrorWindow

#
Class SDForwarderApplication -superclass Application

#
SDForwarderApplication public init argv {
    $self next sdfor

    set o [$self options]
    $self init_args $o
    $self init_resources $o

    $self parse_args $argv
    $self init_scopes
    $self init_forwarders
    $self init_server
}

#
SDForwarderApplication instproc init_args o {
    $o register_boolean_option -tcpServer useTCP
    $o register_boolean_option -noTcpServer useTCP 0
    $o register_boolean_option -noFwdToLocal forwardGlobalToLocal 0

    $o register_list_option -zone sapZones
    $o register_list_option -forward forwards

    $o register_option -p serverPort
}

#
SDForwarderApplication instproc init_resources o {
    $o load_preferences "sdfor"

    $o add_default globalSAP 224.2.128.0/17
    $o add_default localSAP 239.255.0.0/16
    $o add_default localSAPBW 2000

    $o add_default useGlobalSAP 1
    $o add_default useLocalSAP 1
    $o add_default forwardGlobalToLocal 1

    #FIXME
    global env
    if {![info exists env(HOME)]} {
        new ErrorWindow {Your HOME environment variable must be set.}
        exit 1
    }
    $o add_default cachedir [file join $env(HOME) .mash nsdr-cache]

    #FIXME ttl for reannouncements
    $o add_default sapTTL 15

    $o add_default useTCP 1

    # defaults
    $o add_default serverPort 12000
}

#
SDForwarderApplication private parse_args {argv} {
    set o [$self options]
    set args [$o parse_args $argv]
    if {[llength $args] > 0} {
	$self fatal "Extra args: $args"
    }
}

#
SDForwarderApplication private get_scope {range} {
    $self instvar scopes_
    foreach s $scopes_ {
	if {$range == [$s range]} {
	    return $s
	}
    }
    return ""
}

#
SDForwarderApplication private init_scopes {} {
    $self instvar scopes_

    #
    # first, instantiate necessary scope objects
    #
    set scopes_ {}
    foreach range [$self get_option sapZones] {
	#FIXME
	set bw [$self get_option localSAPBW]
	lappend scopes_ [new ScopeZone $range $bw]
    }
    if [$self get_option forwardGlobalToLocal] {
	$self add_option useGlobalSAP 1
	$self add_option useLocalSAP 1
    }
    if [$self get_option useGlobalSAP] {
	set range [$self get_option globalSAP]
	if {[$self get_scope $range] == ""} {
	    lappend scopes_ [new ScopeZone $range]
	}
    }
    if [$self get_option useLocalSAP] {
	set range [$self get_option localSAP]
	if {[$self get_scope $range] == ""} {
	    set bw [$self get_option localSAPBW]
	    lappend scopes_ [new ScopeZone $range $bw]
	}
    }
}

#
SDForwarderApplication private init_forwarders {} {
    $self instvar forwarders_
    #
    # instantiate forwarder objects
    #
    set forwarders_ {}
    foreach fwd [$self get_option forwards] {
	set l [split $fwd ,]
	set range1 [lindex $l 0]
	set range2 [lindex $l 1]
	set zone1 [$self get_scope $range1]
	set zone2 [$self get_scope $range2]

	if {$zone1 == "" || $zone2 == ""} {
	    $self fatal "Can't forward unknown zone ($range1 or $range2)"
	}

	lappend forwarders_ [new SAPForwarder $zone1 $zone2]
    }
}

#
SDForwarderApplication private init_server {} {
    $self instvar scopes_ cache_ source_ server_ ers_

    if ![$self get_option useTCP] { return }

    set server_port [$self get_option serverPort]

    set cache_ [new ProgramCache]
    set source_ [eval new ProgramSource/SAP $cache_ $scopes_]
    set server_ [new TCP/Server]
    $server_ open $server_port "$self create_server"

    set ers_ {}
    foreach scope $scopes_ {
	set spec [split [$scope sapAddr] /]
	set addr [lindex $spec 0]
	set port [lindex $spec 1]
	set ersspec "$addr/[expr $port + 1]"
	lappend ers_ [new ERSServer/Sdfor $server_port $ersspec]
    }
}


SDForwarderApplication private create_server { chan } {
    set o [new SdforServer $self]
    $o open $chan
    return $o
}
