# fx_tselect.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1999-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import RTPApplication
import TemporalSelector

Class FXTSelectApp -superclass RTPApplication

FXTSelectApp instproc init args {
    $self next tselect_app

    $self init_resources;

    [$self options] register_option -comm_id comm_id
    [$self options] register_option -cntrl_spec cntrl_spec

    eval [$self options] parse_args $args;

    $self instvar tselect_obj_

    set tselect_obj_ [new TemporalSelector [$self get_option comm_id] [$self get_option cntrl_spec]];
}

FXTSelectApp instproc init_resources {} {
    [$self options] register_option -gen_spec gen_spec

    $self add_option network ip
    $self add_option mtu 1024
    $self add_option defaultTTL 32
    $self add_option sessionType rtpv2
    $self add_option maxVideoSessionBW 30000000
    $self add_option comm_id ts
    $self add_option cntrl_spec 224.3.2.1/22334/16

    expr srand([clock clicks]);
    set r1 [expr int(rand()*253)+1];
    set r2 [expr int(rand()*253)+1];
    $self add_option gen_spec 224.6.${r1}.${r2};
}

FXTSelectApp instproc remote_exit {} {
    exit;
}

set app [new FXTSelectApp $argv];

puts "Selector running on [exec hostname]";

#if {![info exists tk_version]} {
#    vwait forever;
#}
