# sc-fade-subprogram.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import DaliSubprogram
import RealParameter

Class ScFadeSubprogram -superclass DaliSubprogram

ScFadeSubprogram instproc init {args} {
    eval $self next $args;

    # Set up inputs

    $self instvar input_id_list_;
    $self instvar input_info_;

    lappend input_id_list_ i1

    set input_info_(i1,spec) "";
    set input_info_(i1,trigger) 0;
    set input_info_(i1,buffertype) Semicompressed;
    set input_info_(i1,buffername) [new VidRep/Semicompressed];
    set input_info_(i1,decoder) "";

    lappend input_id_list_ i2

    set input_info_(i2,spec) "";
    set input_info_(i2,trigger) 0;
    set input_info_(i2,buffertype) Semicompressed;
    set input_info_(i2,buffername) [new VidRep/Semicompressed];
    set input_info_(i2,decoder) "";

    # Set up outputs

    $self instvar output_id_list_;
    $self instvar output_info_;

    lappend output_id_list_ o1;

    set output_info_(o1,spec) "";
    set output_info_(o1,buffertype) Semicompressed;
    set output_info_(o1,buffername) [new VidRep/Semicompressed];
    set output_info_(o1,encoder) "";
    set output_info_(o1,format) JPEG;
    set output_info_(o1,vagent) "";

    # Set up parameters

    $self instvar parameter_id_list_;
    $self instvar parameter_info_;

    lappend parameter_id_list_ factor
    set pobj [new RealParameter];

    set parameter_info_(factor,oname) $pobj;
    $pobj from 0.0
    $pobj to 1.0
    $pobj set 0.0
}

ScFadeSubprogram instproc trigger {} {
    $self instvar parameter_info_;
    $self instvar input_info_;
    $self instvar output_info_;
    $self instvar init_done_;
    $self instvar temp_a temp_b temp_out;
    $self instvar rescale_output_flag_;

    set in_frame_a $input_info_(i1,buffername);
    set in_frame_b $input_info_(i2,buffername);
    set out_frame $output_info_(o1,buffername);

    if {![info exists init_done_]} {
	if {[$in_frame_a set w_] == 0} {
	    return;
	}
	if {[$in_frame_b set w_] == 0} {
	    return;
	}
	$out_frame copy_geometry $in_frame_a;
	if {$output_info_(o1,format) == "JPEG"} {
	    $out_frame set h_subsample_ 2;
	    $out_frame set v_subsample_ 1;
	} else {
	    $out_frame set h_subsample_ 2;
	    $out_frame set v_subsample_ 2;
	}
	$out_frame allocate;

	set temp_a [new VidRep/Semicompressed];
	$temp_a copy_geometry $in_frame_a;
	$temp_a allocate;

	set temp_b [new VidRep/Semicompressed];
	$temp_b copy_geometry $in_frame_b;
	$temp_b allocate;

	if {[$out_frame set v_subsample_] != [$temp_a set v_subsample_]} {
	    set rescale_output_flag_ 1;
	    set temp_out [new Semicompressed];
	    $temp_out copy_geometry $temp_a;
	    $temp_out allocate;
	} else {
	    set rescale_output_flag_ 0;
	}
	set init_done_ 1;
    }

    set in_l_a [$in_frame_a get_lum_name];
    set in_cr_a [$in_frame_a get_cr_name];
    set in_cb_a [$in_frame_a get_cb_name];

    set in_l_b [$in_frame_b get_lum_name];
    set in_cr_b [$in_frame_b get_cr_name];
    set in_cb_b [$in_frame_b get_cb_name];

    set temp_l_a [$temp_a get_lum_name];
    set temp_cr_a [$temp_a get_cr_name];
    set temp_cb_a [$temp_a get_cb_name];

    set temp_l_b [$temp_b get_lum_name];
    set temp_cr_b [$temp_b get_cr_name];
    set temp_cb_b [$temp_b get_cb_name];

    set out_l [$out_frame get_lum_name];
    set out_cr [$out_frame get_cr_name];
    set out_cb [$out_frame get_cb_name];

    set factor [$parameter_info_(factor,oname) get];

    sc_scalar_mult $in_l_a $temp_l_a $factor;
    sc_scalar_mult $in_cr_a $temp_cr_a $factor;
    sc_scalar_mult $in_cb_a $temp_cb_a $factor;

    sc_scalar_mult $in_l_b $temp_l_b [expr 1.0 - $factor];
    sc_scalar_mult $in_cr_b $temp_cr_b [expr 1.0 - $factor];
    sc_scalar_mult $in_cb_b $temp_cb_b [expr 1.0 - $factor];

    if {$rescale_output_flag_ == 1} {
	puts "Ooops"
    } else {
	sc_add $temp_cr_a $temp_cr_b $out_cr;
	sc_add $temp_cb_a $temp_cb_b $out_cb;
    }
    sc_add $temp_l_a $temp_l_b $out_l;

    $out_frame set ts_ [$in_frame_a set ts_];

    set encoder $output_info_(o1,encoder);

    if {$encoder != ""} {
	$encoder recv $out_frame;
    }
    $self send_completion_token;
}
