# fca-modrcvr.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


Class FCARcvr/Tcl/Moderator -superclass FCARcvr/Tcl
FCARcvr/Tcl/Moderator instproc init { mgr srcId } {
    $self next $mgr $srcId
    $self set repairRequest_ ""
    $self set repairReply_ ""
    $self set test_ 1
}

#--- SRM callbacks ---#
FCARcvr/Tcl/Moderator instproc handle_request { fcaPkt } {
    $self instvar repairRequest_ mgr_
    DbgOut "FCARcvr/Tcl/Moderator::handle_request, modrcvr_obj($self)"

    set rreqState [$fcaPkt set moderatorState]
    if {$repairRequest_ != ""} {
	set myRqState [$repairRequest_ moderator_state]
	if {$rreqState >= $myRqState} {
	    DbgOut "FCARcvr/Tcl/Moderator::handle_request, backoff"
	    $repairRequest_ backoff
	    return
	}
    }
    set fcd [$mgr_ fcDynamics]
    set myState [$fcd moderator_state]
    if {$myState >= $rreqState} {
	$self make_repair_reply $myState
    }
}


FCARcvr/Tcl/Moderator instproc make_repair_reply {state} {
    $self instvar repairReply_ mgr_ srcId_

    if {$repairReply_ != ""} {
	DbgOut "FCARcvr/Tcl/Moderator::make_repair_reply a repair reply has\
		already been scheduled"
	DbgOut "!!! repairReply_ is of class [$repairReply_ info class]"
	set curRpyState [$repairReply_ state]
	if {$curRpyState >= $state } {
	    DbgOut "FCARcvr/Tcl/Moderator::make_repair_reply, a repair \
		    only made, don't need to make the repair anymore"
	    return
	}
	$repairReply_ cancel
	delete $repairReply_
	set repairReply_ ""
    }
    set repairReply_ [new FCARepairReply/Tcl/Moderator]
    set fcd [$mgr_ fcDynamics]
    $repairReply_ set_state [$fcd moderator_state]
    $repairReply_ set pktGrantUpdate [$fcd make_grant_pkt]
    $repairReply_ set pktQueueUpdate [$fcd make_queue_pkt]
    $mgr_ sched_reply $repairReply_ $srcId_
    DbgOut "FCARcvr/Tcl/Moderator::make_repair_reply, a repair reply is\
	    just scheduled"
}


FCARcvr/Tcl/Moderator instproc handle_queue_update_repair { fcaPkt } {
    $self instvar mgr_

    set fcDynamics [$mgr_ fcDynamics]
    set newStateNum [$fcaPkt set moderatorState]
    $fcDynamics set_moderator_state $newStateNum
    set numUpdates [$fcaPkt set numUpdates]
    set pktUpdates [$fcaPkt set pktUpdates]
    if { $numUpdates != [llength $pktUpdates]} {
	DbgOut "FCARcvr/Tcl/Moderator::handle_queue_update_repair, \
		numUpdates != number of grants within pktUpdates"
    }

    # creating new admitted list
    set newAdmittedRqs [new FCA_RequestList/Bounded [$mgr_ fcPolicy]]

    foreach i $pktUpdates {
	set srcId [$i set srcId]
	set requestId [$i set requestId]
	set allRequests [[$mgr_ getRcvr $srcId] get_requests]
	if { ![$allRequests is_canceled $requestId] } {
	    # add requests to admitted requests
	    $newAdmittedRqs add $srcId $requestId
	    $fcDynamics delete_pending_request $srcId $requestId
	    if { [$allRequests dont_have $requestId] } {
		DbgOut "Don't have request for $srcId:$requestId"

		# let the rcvr know that we ought to have got this stuff
		$allRequests got_request $requestId {}

		# make a repair request
		DbgOut "FCARcvr/Tcl/Moderator::handle_queue_update_repair, \
			make repair request "
		set rcvr [$mgr_ getRcvr $srcId]
		set needSched \
			[$rcvr make_repair_request 0 $requestId $requestId]
		if {$needSched} {
		    DbgOut "handle_queue_update_repair: \
			    repairRequest [$rcvr repair_request]"
		    $mgr_ sched_request [$rcvr repair_request] $srcId
		}
	    }
	}
    }


    set admittedRqs [$fcDynamics admitted_requests]
    set admittedRqList [$admittedRqs get_list]
    # for each of the old admitted request, if not in the new admitted
    # request list, should be removed from the final admitted list
    foreach rq $admittedRqList {
	set srcId [lindex $rq 0]
	set requestId [lindex $rq 1]
	if {![$newAdmittedRqs exists $srcId $requestId]} {
	    $fcDynamics remove_admitted_request $srcId $requestId
	}
    }

    # for each of the new admitted request, if not in the old admitted
    # request list, should be added to the final admitted list
    set newAdmittedRqList [$newAdmittedRqs get_list]
    foreach rq $newAdmittedRqList {
	set srcId [lindex $rq 0]
	set requestId [lindex $rq 1]
	if {![$admittedRqs exists $srcId $requestId]} {
	    $fcDynamics admit_request $srcId $requestId
	}
    }

    delete $newAdmittedRqs
}


FCARcvr/Tcl/Moderator instproc handle_grant_update_repair { fcaPkt } {
    $self instvar mgr_

    set fcDynamics [$mgr_ fcDynamics]
    set newStateNum [$fcaPkt set moderatorState]
    $fcDynamics set_moderator_state $newStateNum

    set numUpdates [$fcaPkt set numUpdates]
    if {$numUpdates == 0} {
	DbgOut "FCARcvr/Tcl/Moderator::handle_grant_update_repair, \
		numUpdates = 0"
	return
    }
    set pktUpdates [$fcaPkt set pktUpdates]
    if { $numUpdates != [llength $pktUpdates]} {
	DbgOut "numUpdates != number of grants within pktUpdates"
    }

    set grantInstList ""

    foreach i $pktUpdates {
	set grantSeqNo [$i set grantSeqno]
	set srcId [$i set srcId]
	set requestId [$i set requestId]
	set floorType [$i set floorType]
	set instance [$i set floorInstance]

	lappend grantInstList [list $floorType $instance]

	set instObj [$fcDynamics getFloorInstanceObj $floorType $instance]
	set allRequests [[$mgr_ getRcvr $srcId] get_requests]
	if { [$allRequests is_canceled $requestId] } {
	    # this request has already been canceled
	    not_implemented "release this grant instance"
	    return
	}

	set request [$allRequests get $requestId]
	$fcDynamics grant_floor $floorType $instance $srcId \
		$requestId $grantSeqNo
    }

    # evacuate the other floorType and instances not mentioned in the repair
    foreach inst $grantInstList {
	set ftype [lindex $inst 0]
	set instance [lindex $inst 1]
	$fcDynamics evacuate $ftype $instance
    }
}


FCARcvr/Tcl/Moderator instproc handle_reply {fcaPkt } {
    $self instvar mgr_ repairReply_ repairRequest_

    set fcd [$mgr_ fcDynamics]
    set myModState [$fcd moderator_state]
    set qUpdate [$fcaPkt set pktQueueUpdate]
    set grantUpdate [$fcaPkt set pktGrantUpdate]
    set rrpyState [$qUpdate set moderatorState]

    if {$myModState < $rrpyState } {
	$fcd reset
	$self handle_queue_update $qUpdate
	$self handle_grant_update $grantUpdate
	# cancel repair request:

	if { $repairRequest_ != "" } {
	    set rqState [$repairRequest_ moderator_state]
	    if {$rqState <= $rrpyState} {
		$repairRequest_ cancel
		delete $repairRequest_
		set repairRequest_ ""
	    }
	}
	return
    }

    #cancel repair reply
    if {$repairReply_ != "" } {
	set myRrpyState [$repairReply_ state]
	if {$rrpyState >= $myRrpyState} {
	    DbgOut "FCARcvr/Tcl/Moderator::handle_reply, my repair reply \
		    canceled"
	    $repairReply_ cancel
	    delete $repairReply_
	    set repairReply_ ""
	}
    }
}


FCARcvr/Tcl/Moderator instproc handle_SA {fcaPkt}  {
    $self instvar repairRequest_ mgr_ srcId_
    DbgOut "handle_SA::FCARcvr/Tcl/Moderator, newState = [$fcaPkt set currentState]"
    set fcd [$mgr_ fcDynamics]
    set myState [$fcd moderator_state]
    set newState [$fcaPkt set currentState]
    if { $myState >= $newState } {
	DbgOut "myState($myState) newState($newState) \
		FCARcvr/Tcl/Moderator::handle_SA"
#	after 5000
	return
    }
#    after 1000
    if { $repairRequest_ == "" } {
	set repairRequest_ [new FCARepairRequest/Tcl/Moderator $newState]
	$mgr_ sched_request $repairRequest_ $srcId_
	DbgOut "new repairRequest newed and sent out"
#	after 1000
	return
    }

    set rqState [$repairRequest_ moderator_state]
    if {$rqState >= $newState} {
	DbgOut "currently requested state ($rqState) is newer than \
		newState ($newState)"
	return
    }
    $repairRequest_ set_moderator_state $newState
#    after 1000
}

# HERE!!
#FCARcvr/Tcl/Moderator instproc handle_SA {fcaPkt} {
#    $self instvar mgr_ srcId_ repairRequest_
#    set fcd [$mgr_ fcDynamics]
#    set myModState [$fcd moderator_state]
#    set newState [$fcaPkt set currentState]
#    DbgOut "saModState = $newState, FCARcvr/Tcl/Moderator::handle_SA,"
#    DbgOut "FCARcvr/Tcl/Moderator::handle_SA, repairRequest = $repairRequest_"
#    if { $myModState >= $newState } {
#	DbgOut "FCARcvr/Tcl/Moderator::handle_SA, \
#		myModState ($myModState) >= newState ($newState)"
#	return
#    }
#    if { $repairRequest_ != "" } {
#	DbgOut "repairRequest is not empty"
#	DbgOut "of class [$repairRequest_ info class]"
##	DbgOut "moderatorState = [$repairRequest_ set moderatorState]"
#    } else {
#	DbgOut "repairRequest is empty"
#    }
## if { [info exist [$RepairRequest_ set moderatorState] } {
#    if { $repairRequest_ == "" } {
#	DbgOut "RepairRequest is empty"
#	set needSched 1
#	set repairRequest_ [new FCARepairRequest/Tcl/Moderator $newState]
#	$mgr_ sched_request $repairRequest_ $srcId_
#	DbgOut "Repair request ($repairRequest_) sent out"
#    } else {
#	if { $newState > [$repairRequest_ moderator_state] } {
#	    $repairRequest_ set_moderator_state $newState
#	    DbgOut "Repair request has new state $newState"
#	}
#    }
#}




FCARcvr/Tcl/Moderator instproc recv { fcaPkt } {
    set pktType [$fcaPkt set pktType]
    switch $pktType {
	"PKT_FLOOR_REQUEST" {
	    $self handle_floor_request $fcaPkt
	}
	"PKT_FLOOR_CANCEL" {
	    $self handle_floor_cancel $fcaPkt
	}
	"PKT_GRANT_UPDATE" {
	    $self handle_grant_update $fcaPkt
	}
	"PKT_QUEUE_UPDATE" {
	    $self handle_queue_update $fcaPkt
	}
	"PKT_CANCEL_UPDATE" {
	    $self handle_cancel_update $fcaPkt
	}
	default {
	    DbgOut ""should not receive $pktType here!"
	}
    }
}


# assume single moderator now -> local receiver is not a moderator
# for multiple moderators, check whether local receiver is moderator,
# then send out update messages
FCARcvr/Tcl/Moderator instproc handle_grant_update {fcaPkt} {
    $self instvar mgr_

    ###!!! testing handle_sa
    DbgOut "modrcvr ignore grant update [$fcaPkt set moderatorState]"
    return


    set fcDynamics [$mgr_ fcDynamics]
    set curStateNum [$fcDynamics moderator_state]
    set newStateNum [$fcaPkt set moderatorState]
    if { $newStateNum != [expr $curStateNum+1] } {
	DbgOut "invalid moderator update received; ignoring it"
	return
    }

    $fcDynamics set_moderator_state $newStateNum
    set numUpdates [$fcaPkt set numUpdates]
    set pktUpdates [$fcaPkt set pktUpdates]
    if { $numUpdates != [llength $pktUpdates]} {
	DbgOut "numUpdates != number of grants within pktUpdates"
    }

    if { [$fcaPkt set pktType]=="PKT_GRANT_UPDATE" } {
	set isGrant 1
    } else {
	set isGrant 0
    }

    foreach i $pktUpdates {
	set grantSeqNo [$i set grantSeqno]
	set srcId [$i set srcId]
	set requestId [$i set requestId]
	set floorType [$i set floorType]
	set instance [$i set floorInstance]

	if { ![$fcDynamics gr_is_stale $floorType $instance $grantSeqNo] } {
	    # if not stale grant/release

	    set instObj [$fcDynamics getFloorInstanceObj $floorType $instance]
	    set allRequests [[$mgr_ getRcvr $srcId] get_requests]
	    if { [$allRequests is_canceled $requestId] } {
		# this request has already been canceled
		not_implemented "release this grant instance"
		return
	    }

	    set request [$allRequests get $requestId]
	    if {$isGrant} {
		$fcDynamics grant_floor $floorType $instance $srcId \
			$requestId $grantSeqNo
	    } else {
		not_implemented "release"
		$fcDynamics releaseHolder $floorType $instance $grantSeqNo
		# update UI
		[$mgr_ set uiMgr_] release_received $floorType $instObj
	    }
	}
    }
}



FCARcvr/Tcl/Moderator instproc handle_queue_update {fcaPkt} {
    $self instvar mgr_ test_

    ###!!! testing handle_sa
    if {$test_} {
	set test_ 0
	DbgOut "FCARcvr/Tcl/Moderator, ignore queue update, testing mod handle_sa"
	return
    }


    set fcDynamics [$mgr_ fcDynamics]
    set curStateNum [$fcDynamics moderator_state]
    set newStateNum [$fcaPkt set moderatorState]
    if { $newStateNum <= $curStateNum } {
	DbgOut "current state is more recent than new state, dump queue update"
	return
    }

    set numUpdates [$fcaPkt set numUpdates]
    set pktUpdates [$fcaPkt set pktUpdates]

    $fcDynamics set_moderator_state $newStateNum

    foreach i $pktUpdates {
	set isAdd [$i set isAdd]
	set srcId [$i set srcId]
	set requestId [$i set requestId]

	if {$isAdd} {
	    set allRequests [[$mgr_ getRcvr $srcId] get_requests]

	    if { ![$allRequests is_canceled $requestId] } {
		# add requests to admitted requests
		$fcDynamics admit_request $srcId $requestId
		$fcDynamics delete_pending_request $srcId $requestId

		if { [$allRequests dont_have $requestId] } {
		    DbgOut "Don't have request for $srcId:$requestId"

		    # let the rcvr know that we ought to have got this stuff
		    $allRequests got_request $requestId {}

		    # make a repair request
		    DbgOut "FCARcvr/Tcl/Moderator::handle_queue_update, \
			    make repair request "
		    set rcvr [$mgr_ getRcvr $srcId]
		    set needSched \
			    [$rcvr make_repair_request 0 $requestId $requestId]
		    if {$needSched} {
			DbgOut "handle_queue_update: \
				repairRequest [$rcvr repair_request]"
			$mgr_ sched_request [$rcvr repair_request] $srcId
		    }

		}
	    }
	} else {
	    $fcDynamics remove_admitted_request $srcId $requestId
	    # if there is a cancel message for this request, obsolete it out
	    [$mgr_ getRcvr $srcId] obsolete_important cancel $requestId
	}
    }
}



# whether at srcId there is a release for grantSeq
FCARcvr/Tcl/Moderator instproc isPendingRls {srcId grantSeq} {
    $self instvar mgr_ pendingRls_
    set rcvr [$mgr_ getRcvr $srcId]
    return [info exist pendingRls_($grantSeq)]
}

