# application-transcoder.tcl --
#
#       Creates a transcoder agent to transcode video.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import RTPApplication
import CTranscoderAgent

#
# Code for CVideoTranscoderApplication
#

Class CVideoTranscoderApplication -superclass RTPApplication

CVideoTranscoderApplication instproc InitArgs { options } {
    $options register_option -megactrl optSpecAS
    $options register_option -serventInstance optServentInstance
}

CVideoTranscoderApplication instproc InitResources { options } {
	$options add_default optSpecAS 224.4.5.25/50000/31
	$options add_default optiBW 20000

	$options add_default siteDropTime 300
}

CVideoTranscoderApplication instproc init { argv } {
    $self next VideoTranscoderServent


    # Initialization of variables and resources.
    set options [$self options]
    $self InitArgs $options
    $self InitResources $options
    $options load_preferences "video transcoder"
    set argv [$options parse_args $argv]

    # get some options
    set specAS [$options get_option optSpecAS]
    set iBW [$options get_option optiBW]
    set serventInstance [$options get_option optServentInstance]

    # create the agent that will take to the AS
    set m_agent [new CTranscoderAgent $specAS $iBW $serventInstance]
}

