# mb-record.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/archive/recorder/mb-record.tcl,v 1.20 2002/02/03 04:25:14 lim Exp $


# MB_Manager/Record isn't implemented yet.
#
#import SRMAgent ArchiveSession/Record \
#	ArchiveSession/Record/Mediaboard AddressBlock \
#	MB_Manager/Record ArchiveStream/Record

import SRMAgent ArchiveSession/Record \
	ArchiveSession/Record/Mediaboard AddressBlock \
	ArchiveStream/Record

# Implements recording functionality for the mediaboard application.
# Eventually, there should be a SRM recorder which specializes to
# mediaboard.
# Status: Beta
# Author: Yatin Chawathe

# MB_Manager/Record isn't implemented yet.
#
#Class ArchiveSession/Record/Mediaboard \
#		-superclass {ArchiveSession/Record MB_Manager/Record}
Class ArchiveSession/Record/Mediaboard \
		-superclass {ArchiveSession/Record}
Class ArchiveSession/Record/SRM -superclass ArchiveSession/Record/Mediaboard

ArchiveSession/Record/Mediaboard instproc init { media addr } {
	$self next $media
	$self instvar session_ sm_ agent_

        set agent_ [new SRMAgent 0xFFFFFF]
	set session_ [$agent_ create-session $self $self]

	$self reset $addr
	$self attach_session $session_

#	global mb
#	set mb(debug) [new Debug $self 0]
}


ArchiveSession/Record/Mediaboard instproc destroy { } {
    	$self instvar agent_
    	delete $agent_
	$self next
}


ArchiveSession/Record/Mediaboard instproc reset { addr } {
	$self instvar session_ agent_
	set had_network [$agent_ have_network]
	set ab [new AddressBlock $addr]
	$agent_ reset $ab
	delete $ab
	set net [$agent_ set network_]
	[$net data-net] loopback 1
	[$net ctrl-net] loopback 1

        # do this for the first time only
	if !$had_network {
		$session_ start_timers
	}
}


ArchiveSession/Record/Mediaboard instproc srm_session { } {
	return [$self set session_]
}


ArchiveSession/Record/Mediaboard instproc srm_source_mgr { } {
	return [$self set sm_]
}


ArchiveSession/Record/Mediaboard instproc new_source { src } {
}


ArchiveStream/Record/Mediaboard instproc init { session } {
	$self next $session
	$self init_file_header

	# schedule a timer for every 2 seconds to write the header
	$self set after_id_ [after 2000 "$self do_periodic"]
}


ArchiveStream/Record/Mediaboard instproc destroy { } {
	$self instvar after_id_
	if [info exists after_id_] {
		after cancel $after_id_
		unset after_id_
	}
	$self next
}


ArchiveStream/Record/Mediaboard private do_periodic { } {
	# write the headers to the data and index files (do so only if
	# something has changed)
	$self write_headers
	$self set after_id_ [after 2000 "$self do_periodic"]
}
