/*
 * srmv2.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef srmv2_h
#define srmv2_h

#include "config.h"
#include <stdio.h>
#include "timer.h"
#include "pktbuf.h"

#define PROTOTYPES 1
#include "global.h"
extern "C" {
#include "md5.h"
}

#ifdef _MSC_VER
/*warning C4200: nonstandard extension used : zero-sized array in ...*/
#pragma warning( disable : 4200 )
#endif

#define SRMv2_FRAG 1
#define SRMv2_VERSION 2
/* FIXME: remove this, should be internal variable of SRMv2 */
#define SRMv2_MTU 1024
#define SRMv2_MAPPINGS 1

#define SRMv2_BIND     1
#define SRMv2_RREQ     2
#define SRMv2_ANNOUNCE 3
#define SRMv2_DELAYS   4
#define SRMv2_DATA     5
#define SRMv2_REXMIT   6
#define SRMv2_NSREPAIR 7

#define SRMv2_PROTO    1
#define DUMMY         -1
#define SRMv2_OK       1
#define SRMv2_LOSS     0
#define SRMv2_ERROR 0xffffffff
#define MAX_BACKOFF_FACTOR 1024
#define MIN_BACKOFF_DELAY  50.0 /* While no RTT ests. are available, return a
				   conservative one-way delay of 50 ms. */
#define MAX_ADUNAME_LEN 128
#define NET_MTU    PKTBUF_SIZE
#define SRMv2HDR_SIZE (sizeof(srmv2_cmnhdr) + sizeof(srmv2_conhdr) + sizeof(srmv2_aduhdr))
/*
 * Common SRMv2 header.
 */
struct srmv2_cmnhdr {
	u_int8_t   flags;	/* Version : 2, Padding : 1 */
	u_int8_t   type;        /* SRMv2 Pkt type */
	u_int16_t  unused;
	unsigned int ipaddr;    /* IPv4 address */
};

struct srmv2_conhdr {
	u_int32_t srcid[4];
	u_int32_t cid;
};

struct srmv2_aduhdr {
	u_int8_t  flags;       /* Fragment : 1, Reserved : 7 */
	u_int8_t  atype;
	u_int16_t alen;
	u_int32_t seqno;
	u_int32_t ts[2];
};

typedef u_int32_t srmv2_fraghdr; /* MSbit is the "more" flag */

struct srmv2_rreqhdr {
	u_int32_t ss;
	u_int32_t sbytes;
	u_int32_t es;
	u_int32_t ebytes;
};

struct srmv2_rreqfraghdr {
	u_int32_t sbytes;
	u_int32_t ebytes;
};

struct srmv2_announcehdr {
	u_int32_t cid;
	u_int32_t sign;
	u_int32_t ebytes;
};

/*
 *   t1
 *    \
 *       t2
 *       |
 *       t3
 *     /
 *  t4
 */

/* Delay Information */
struct srmv2_delayhdr {
	unsigned int ip_addr; /* Host IPv4 address. */
	int ow_diff;          /* td is t1 + t3 - t2, in 2^{-16} sec for the latest sample. */
};

struct srmv2_delays {
	unsigned int rtt_est;       /* rtt_est is an EWMA of all the RTT samples from this host. */
	int ow_diff;                /* ow_diff is t2 - t1. Warning, this may NOT even be positive! */
};

#define     MAX(a,b) (((a)>(b))?(a):(b))
#define     MIN(a,b) (((a)<(b))?(a):(b))

inline void md5_digest(const char *in, unsigned char *out)
{
	MD5_CTX context;
	unsigned int len = strlen (in);

	MD5Init (&context);
	MD5Update (&context, (unsigned char *)in, len);
	MD5Final (out, &context);
}
inline float ntp2msec(unsigned ntptime) {
	return (float)((ntptime >> 16)*1000.0 + (ntptime&0xffff)/65.536);
}


#ifdef _MSC_VER
/*warning C4200: nonstandard extension used : zero-sized array in ...*/
#pragma warning( default : 4200 )
#endif


#endif
