# application-hmsim.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/sim/hm/application-hmsim.tcl,v 1.7 2002/02/03 04:16:36 lim Exp $ (UCB)

Class HMSimApplication -superclass Application

HMSimApplication instproc init { argv } {
	set config [new Configuration]
	$self set options_ $config

	$self next hm

	$self init_args $config
	$self init_resources $config
	$config parse_args $argv
	$self init_local

	$self init_sim
}

HMSimApplication instproc init_args o {
	$o register_boolean_option -lb loadBalance

	$o register_option -target targetNum
	$o register_option -hostnum hostNum
	$o register_option -int checkInterval
	$o register_option -end endTime
	$o register_option -log logFile
	$o register_option -ckfact checkFactor
}

HMSimApplication instproc init_resources o {

	$o add_default megaCtrl 224.4.5.24/50000/31
	$o add_default megaCtrlBW 20000
	# 60 seconds max startup wait for first message
	$o add_default megaStartupWait 60

	$o add_default unicastOutput 1

	$o add_default maxWait 2500

	$o add_default minPort 10000
	$o add_default maxPorts 10000

	$o add_default checkFactor 4
	$o add_default checkInterval 20000
	$o add_default deathInterval 10000
	$o add_default minDeathWait 60000

	$o add_default highLoad 85
	$o add_default lowLoad 15
	$o add_default execPath /a/center/src/mash/bin
	$o add_default minHmNum 1
	$o add_default loadSamples 2
	$o add_default logFile stdout

	$o add_default hostNum 4
	$o add_default endTime 10
}

HMSimApplication instproc init_sim {} {
	global ns
	$ns at [$self get_option endTime] "$self finish"

#	ns-random 1239871
	ns-random 0
	set log [$self get_option logFile]
	if { $log != "stdout" } {
		set log [open $log a+]
	}
	set hm [new HMSimAgent 0 $self $log]
	$hm set alice_ 1
}

HMSimApplication instproc finish {} {
	global hmrec

	set max -1
	foreach x $hmrec {
#		puts "[lindex $x 0] [lindex $x 1]"
		set cur [lindex $x 0]
		if { $cur > $max } {
			set max $cur
		}
	}
	puts "$max [$self get_option checkInterval]"
	exit 0
}

