/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.infer;

import com.thaiopensource.xml.infer.DatatypeRepertoire;
import com.thaiopensource.xml.util.Name;

class DatatypeInferrer {
    private final DatatypeRepertoire.Type[] possibleTypes;
    private int nTypes;
    private int typicalMask = 0;
    private final String uri = datatypeRepertoire.getUri();
    private boolean allWhiteSpace = true;

    DatatypeInferrer(DatatypeRepertoire datatypeRepertoire, String string) {
        this.possibleTypes = new DatatypeRepertoire.Type[datatypeRepertoire.size()];
        for (int i = 0; i < this.possibleTypes.length; ++i) {
            this.possibleTypes[i] = datatypeRepertoire.get(i);
        }
        this.nTypes = this.possibleTypes.length;
        this.addValue(string);
    }

    public void addValue(String string) {
        int n = 0;
        for (int i = 0; i < this.nTypes; ++i) {
            if (!this.possibleTypes[i].matches(string)) {
                ++n;
                continue;
            }
            if (this.possibleTypes[i].isTypical(string)) {
                this.typicalMask |= 1 << this.possibleTypes[i].getIndex();
            }
            if (n <= 0) continue;
            this.possibleTypes[i - n] = this.possibleTypes[i];
            this.possibleTypes[i] = null;
        }
        this.nTypes -= n;
        if (!DatatypeInferrer.isWhiteSpace(string)) {
            this.allWhiteSpace = false;
        }
    }

    static boolean isWhiteSpace(String string) {
        block3: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public Name getTypeName() {
        for (int i = 0; i < this.nTypes; ++i) {
            if ((1 << this.possibleTypes[i].getIndex() & this.typicalMask) == 0) continue;
            return new Name(this.uri, this.possibleTypes[i].getName());
        }
        return null;
    }

    public boolean isAllWhiteSpace() {
        return this.allWhiteSpace;
    }
}

