<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/language.php");
include_once("./include/theme.php");

include_once("./functions/function.php");
include_once("./functions/utils.php");
include_once("./functions/parseutils.php");
include_once("./functions/http.php");
include_once("./functions/site.php");
include_once("./functions/widgets.php");

// specific site functions
if(file_exists("./site/".$HTTP_VARS['site']."/functions.php"))
	include_once("./site/".$HTTP_VARS['site']."/functions.php");
	
if(file_exists("./site/".$HTTP_VARS['site']."/config.php"))	
	include_once("./site/".$HTTP_VARS['site']."/config.php");

/**
	Get back to item_add link block here, so we can maintain some kind
	of standard nature for the plugins.
*/
function get_new_search_link($HTTP_VARS)
{
	global $LANG_VARS;

	$http_url_vars = get_url_string($HTTP_VARS);
	echo format_footer_links(array(array(url=>"item_add.php".(strlen($http_url_vars)>0?"?".get_url_string($HTTP_VARS):""),text=>$LANG_VARS['site_new_search'])));
}

// This check will also be performed in each site plugin, but who cares!
session_start();
if (is_opendb_valid_session())
{
	$page_title = replace_lang_var("sitetitle", $site_title, $LANG_VARS['title_search']);

	echo _theme_header($page_title);

    echo "<h2>".$page_title."</h2>";

	echo "<div class=\"colortext\">";
	include("./site/".$HTTP_VARS['site']."/index.php");
	echo "</div>";

	// Allows individual site plugins to disable display of new search link
	if($show_new_search_link!==FALSE)
	{
		echo get_new_search_link(
				array('item_id'=>$HTTP_VARS['item_id'], 
					'instance_no'=>$HTTP_VARS['instance_no'],
					'parent_id'=>$HTTP_VARS['parent_id'],
					'parent_instance_no'=>$HTTP_VARS['parent_instance_no'],
					's_status_type'=>$HTTP_VARS['s_status_type'],
					'listing_link'=>$HTTP_VARS['listing_link']
					));
	}

	echo _theme_footer();
}
else//not a valid session.
{
	include("./include/invalidsession.php");
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>
