<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./functions/widgets.php");
include_once("./functions/function.php");
include_once("./functions/http.php");

session_start();

opendb_log("User logged out (user_id=".$HTTP_SESSION_VARS['user_id'].")");

if(is_register_globals_enabled())
{
	// PHP manual suggests unregistering globals
	session_unregister("user_id");
	session_unregister("user_type");
	session_unregister("user_theme");
	session_unregister("user_language");
	session_unregister("hash_check");
	session_unregister("login_time");
	session_unregister("last_access_time");
}

// Explicitly set to null!
$HTTP_SESSION_VARS['user_id'] = NULL;
$HTTP_SESSION_VARS['user_theme'] = NULL;
$HTTP_SESSION_VARS['user_language'] = NULL;
$HTTP_SESSION_VARS['user_type'] = NULL;
$HTTP_SESSION_VARS['hash_check'] = NULL;
$HTTP_SESSION_VARS['login_time'] = NULL;
$HTTP_SESSION_VARS['last_access_time'] = NULL;

// close session
session_destroy();

include_once("./include/language.php");
include_once("./include/theme.php");

// No session variables available once logged out!!!
echo _theme_header($LANG_VARS['logout']);

echo("<h2>".$LANG_VARS['logout']."</h2>");

// In some cases this will cause menu frame to be refreshed.
echo _theme_refresh_menu();

echo("<div class=\"colortext\">");
$myid = session_id();// double check for any errors
if( $myid=="")
	echo("<p>".replace_lang_var("site", $CONFIG_VARS['site.title']." ".$CONFIG_VARS['site.version'], $LANG_VARS['thanks_for_using'])."</p>\n");
else									
	echo("<p>".$LANG_VARS['unable_to_logout']."</p>\n");

echo("<br>");

echo format_footer_links(array(array(url=>"login.php",text=>$LANG_VARS['return_to_login_page'])));
echo("</div>");

// No session variables available once logged out!!!
echo _theme_footer();

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>

