<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once('./functions/item_type.php');

function check_item_type_structure($s_item_type, &$error)
{
	global $CONFIG_VARS;
	
	if(is_exists_item_type($s_item_type))
	{
		$missing_s_field_types = NULL;
		
		if(!fetch_sfieldtype_item_attribute_type($s_item_type,'TITLE'))
			$missing_s_field_types[] = 'TITLE';
		
		if(!fetch_sfieldtype_item_attribute_type($s_item_type,'STATUSTYPE'))
			$missing_s_field_types[] = 'STATUSTYPE';
			
		if(!fetch_sfieldtype_item_attribute_type($s_item_type,'STATUSCMNT'))
			$missing_s_field_types[] = 'STATUSCMNT';
			
		if(!fetch_sfieldtype_item_attribute_type($s_item_type,'CATEGORY'))
			$missing_s_field_types[] = 'CATEGORY';
		
		if($CONFIG_VARS['borrow.enable']!==FALSE && $CONFIG_VARS['borrow.duration_support']!==FALSE)
		{
			if(!fetch_sfieldtype_item_attribute_type($s_item_type,'DURATION'))
				$missing_s_field_types[] = 'DURATION';
		}
		
		if(is_not_empty_array($missing_s_field_types))
		{
			$error = array('error'=>'The following Field Type attribute relationships are missing.',
							'detail'=>$missing_s_field_types);
							
			return FALSE;
		}
		else // No errors so no problem.
			return TRUE;
	}
	else // no message if s_item_type does not even exist.
		return FALSE;
}


/**
* If any items found with the specified s_item_type, then
* the s_item_type is not deletable.
*/
function is_s_item_type_deletable($s_item_type)
{
	$query = "SELECT 'x' FROM item i WHERE i.s_item_type='".$s_item_type."'";
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		mysql_free_result($result);
		return FALSE;
	}

	//else
	return TRUE;
}

/**
* If any item_attributes found with the specified s_item_type, s_attribute_type
* and order_no then the s_item_attribute_type record is not deletable.
*/
function is_s_item_attribute_type_deletable($s_item_type, $s_attribute_type, $order_no)
{
	$query = "SELECT 'x' FROM item i, item_attribute ia ".
			"WHERE i.id = ia.item_id AND i.s_item_type = '$s_item_type' AND ".
			"ia.s_attribute_type = '$s_attribute_type' AND ia.order_no = '$order_no'";
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		mysql_free_result($result);
		return FALSE;
	}

	//else
	return TRUE;
}

/*
* Used for other things besided s_item_type construction
*/
function is_attribute_type_avail_for_item_types($s_attribute_type)
{
	if($s_attribute_type == 'S_RATING')
		return FALSE;
	else
		return TRUE;
}

/**
*/
function is_exists_item_attribute_type_field_type($s_item_type, $s_field_type)
{
	$query = "SELECT 'x' FROM s_item_attribute_type siat, s_attribute_type sat ".
			"WHERE siat.s_attribute_type = sat.s_attribute_type AND siat.s_item_type = '$s_item_type' AND sat.s_field_type = '$s_field_type'";
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		mysql_free_result($result);
		return TRUE;
	}

	//else
	return FALSE;
}

/**
	Fetch a list of all s_attribute_type's including reserved list.
*/
function fetch_s_attribute_type_rs($orderby = "s_attribute_type", $order = "asc")
{
	$query = "SELECT s_attribute_type, s_field_type, description FROM s_attribute_type ORDER BY $orderby $order";
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
		return $result;
	else
		return FALSE;
}

/*
* Fetch a list of ALL s_attribute_type's
*/
function fetch_sfieldtype_attribute_type_rs($s_field_type, $orderby = "s_attribute_type", $order = "asc")
{
	$query = "SELECT s_attribute_type, description, input_type FROM s_attribute_type WHERE s_field_type = '$s_field_type' ORDER BY $orderby $order";
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
		return $result;
	else
		return FALSE;
}

function fetch_s_item_type_rs($orderby = "order_no", $order = "asc")
{
	$query = "SELECT s_item_type, order_no, description, image, default_site_type FROM s_item_type ORDER BY $orderby $order";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
		return $result;
	else
		return FALSE;
}

function fetch_s_item_attribute_type_rs($s_item_type)
{
	$query = "SELECT s_attribute_type, order_no, prompt, compulsory_ind FROM s_item_attribute_type WHERE s_item_type = '$s_item_type' ORDER BY order_no ASC";
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
		return $result;
	else
		return FALSE;
}

function fetch_s_item_type_r($s_item_type)
{
	$query = "SELECT s_item_type, order_no, description, image, default_site_type FROM s_item_type WHERE s_item_type = '$s_item_type'";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		return $found;
	}
	
	//else
	return FALSE;
}

/*
* This function will insert the initial s_item_type only, no reference to the
* s_item_attribute_type's which will come later.
*/ 
function insert_s_item_type($s_item_type, $order_no, $description, $image, $default_site_type)
{
	global $HTTP_SESSION_VARS;
	
	$description = addslashes(trim(strip_tags($description)));
	$default_site_type = strtolower(trim($default_site_type));

	$query = "INSERT INTO s_item_type (s_item_type, order_no, description, image, default_site_type) "
			."VALUES ('$s_item_type', ".(is_numeric($order_no)?"'$order_no'":"NULL").", '$description','$image','$default_site_type')";
	$update = run_opendb_query($query);
	
	// We should not treat updates that were not actually updated because value did not change as failures.
	$rows_affected = mysql_affected_rows();
	if($update && $rows_affected !== -1)
	{
		if($rows_affected>0)
			opendb_log("Inserted s_item_type (s_item_type=$s_item_type, update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return TRUE;
	}
	else
	{
		opendb_log("Failed to insert s_item_type (s_item_type=$s_item_type, update_who=".$HTTP_SESSION_VARS['user_id']."). [".mysql_error()."]");
		return FALSE;
	}
	
	//else
	return FALSE;
}

function update_s_item_type($s_item_type, $order_no, $description, $image, $default_site_type)
{
	global $HTTP_SESSION_VARS;
	
	$description = addslashes(trim(strip_tags($description)));
	$default_site_type = strtolower(trim($default_site_type));

	$query = "UPDATE s_item_type "
			."SET "
			.($order_no!==FALSE?" order_no = ".(is_numeric($order_no)?"'$order_no', ":"NULL, "):"")
			."description = '$description' "
			.", image = '$image' "
			.", default_site_type = '$default_site_type' "
			."WHERE s_item_type = '$s_item_type'";

	$update = run_opendb_query($query);

	// We should not treat updates that were not actually updated because value did not change as failures.
	$rows_affected = mysql_affected_rows();
	if($update && $rows_affected !== -1)
	{
		if($rows_affected>0)
			opendb_log("Updated s_item_type (s_item_type=$s_item_type, update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return TRUE;
	}
	else
	{
		opendb_log("Failed to update s_item_type (s_item_type=$s_item_type, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
	
	//else
	return FALSE;
}

function delete_s_item_type($s_item_type)
{
	global $HTTP_SESSION_VARS;
	
	$query = "DELETE FROM s_item_type "
			."WHERE s_item_type = '$s_item_type'";

	$delete = run_opendb_query($query);
	
	// We should not treat updates that were not actually updated because value did not change as failures.
	$rows_affected = mysql_affected_rows();
	if($delete && $rows_affected !== -1)
	{
		if($rows_affected>0)
			opendb_log("Deleted s_item_type (s_item_type=$s_item_type, update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return TRUE;
	}
	else
	{
		opendb_log("Failed to delete s_item_type (s_item_type=$s_item_type, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
	
	//else
	return FALSE;
}

function insert_s_item_attribute_type($s_item_type, $s_attribute_type, $order_no, $prompt, $compulsory_ind)
{
	global $HTTP_SESSION_VARS;
	
	$prompt = addslashes(trim(strip_tags($prompt)));
	$s_field_type = strtoupper(trim($s_field_type));

	// Ensure we have a valid compulsory_ind value.	
	$compulsory_ind = strtoupper(trim($compulsory_ind));
	if($compulsory_ind != "Y")
		$compulsory_ind = "N";	
	
	$query = "INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) "
			."VALUES ('$s_item_type', '$s_attribute_type', ".(is_numeric($order_no)?"'$order_no'":"0").", '$prompt', '$compulsory_ind')";
	$update = run_opendb_query($query);
	
	// We should not treat updates that were not actually updated because value did not change as failures.
	$rows_affected = mysql_affected_rows();
	if($update && $rows_affected !== -1)
	{
		if($rows_affected>0)
			opendb_log("Inserted s_item_attribute_type (s_item_type=$s_item_type, s_attribute_type=$s_attribute_type, order_no=$order_no, update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return TRUE;
	}
	else
	{
		opendb_log("Failed to insert s_item_attribute_type (s_item_type=$s_item_type, s_attribute_type=$s_attribute_type, order_no=$order_no, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
	
	//else
	return FALSE;
}

function update_s_item_attribute_type($s_item_type, $s_attribute_type, $order_no, $prompt, $compulsory_ind)
{
	global $HTTP_SESSION_VARS;
	
	$prompt = addslashes(trim(strip_tags($prompt)));

	// Ensure we have a valid compulsory_ind value.	
	$compulsory_ind = strtoupper(trim($compulsory_ind));
	if($compulsory_ind != "Y")
		$compulsory_ind = "N";	
	
	$query = "UPDATE s_item_attribute_type "
			."SET prompt = '$prompt', "
			."compulsory_ind = '$compulsory_ind' "
			."WHERE s_item_type = '$s_item_type' AND s_attribute_type = '$s_attribute_type' AND order_no = '$order_no'";

	$update = run_opendb_query($query);
	
	// We should not treat updates that were not actually updated because value did not change as failures.
	$rows_affected = mysql_affected_rows();
	if($update && $rows_affected !== -1)
	{
		if($rows_affected>0)
			opendb_log("Updated s_item_attribute_type (s_item_type=$s_item_type, s_attribute_type=$s_attribute_type, order_no=$order_no, update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return TRUE;
	}
	else
	{
		opendb_log("Failed to update s_item_attribute_type (s_item_type=$s_item_type, s_attribute_type=$s_attribute_type, order_no=$order_no, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
	
	//else
	return FALSE;
}

function delete_s_item_attribute_type($s_item_type, $s_attribute_type, $order_no)
{
	global $HTTP_SESSION_VARS;
	
	$query = "DELETE FROM s_item_attribute_type "
			."WHERE s_item_type = '$s_item_type'";

	if(strlen($s_attribute_type)>0)
	{			
		$query .= " AND s_attribute_type = '$s_attribute_type' AND order_no = '$order_no'";
	}

	$delete = run_opendb_query($query);
	
	// We should not treat updates that were not actually updated because value did not change as failures.
	$rows_affected = mysql_affected_rows();
	if($delete && $rows_affected !== -1)
	{
		if($rows_affected>0)
			opendb_log("Deleted s_item_attribute_type(s) (s_item_type=$s_item_type".(strlen($s_attribute_type)>0?", s_attribute_type=".$s_attribute_type.",order_no=$order_no":"").", update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return TRUE;
	}
	else
	{
		opendb_log("Failed to delete s_item_attribute_type(s) (s_item_type=$s_item_type".(strlen($s_attribute_type)>0?", s_attribute_type=".$s_attribute_type.",order_no=$order_no":"").", update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
	
	//else
	return FALSE;
}
?>