// 2DAttributesDoc.cpp : implementation of the C2DAttributesDoc class
//

#include "stdafx.h"

#include "2DAttributesDoc.h"

#include "2DAttributesApp.h"

#include "Aspect_ColorMap.hxx"
#include "Aspect_MarkMapEntry.hxx"
#include <Aspect_GenericColorMap.hxx>

#include "Primitive\Sample2D_Markers.h"
#include "Primitive\Sample2D_Line.h"
#include "Primitive\Sample2D_Text.h"

#include "PropertiesSheet.h"

/////////////////////////////////////////////////////////////////////////////
// C2DAttributesDoc

IMPLEMENT_DYNCREATE(C2DAttributesDoc, CDocument)

BEGIN_MESSAGE_MAP(C2DAttributesDoc, CDocument)
	//{{AFX_MSG_MAP(C2DAttributesDoc)
	ON_COMMAND(ID_MENU_CASCADE_PROPERTIES, OnBUTTONTest2DProperties)
	ON_COMMAND(ID_BUTTON_Test_Text, OnBUTTONTestText)
 	ON_COMMAND(ID_BUTTON_Test_Markers, OnBUTTONTestMarkers)
	ON_COMMAND(ID_BUTTON_Test_Line, OnBUTTONTestLine)
	ON_COMMAND(ID_BUTTON_Erase, OnBUTTONErase)

	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// C2DAttributesDoc construction/destruction

C2DAttributesDoc::C2DAttributesDoc()
{
}

C2DAttributesDoc::~C2DAttributesDoc()
{
}

#ifdef _DEBUG
void C2DAttributesDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void C2DAttributesDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// C2DAttributesDoc commands

void C2DAttributesDoc::OnBUTTONTest2DProperties() 
{
// TODO: Add your command handler code here
  CPropertiesSheet aDial;
  aDial.SetViewer(my2DViewer);
  aDial.DoModal();
}

//=================================================================
//=================================================================
//=================================================================

void C2DAttributesDoc::OnBUTTONErase() 
{
   myAISInteractiveContext2D->EraseAll();
  // Update Get information to update Result dialog

  UINT anID=ID_BUTTON_Erase;
  TCollection_AsciiString Message("\
call :    \n\
   myAISInteractiveContext2D->EraseAll();");

  // Update The Result Dialog
  UpdateResultDialog(anID,Message);
}



void C2DAttributesDoc::OnBUTTONTestText() 
{
 Standard_Integer color=1;
 for (Standard_Real j=15;j<=20;j++)
  {
    TCollection_AsciiString Text("font 0 scale ");Text+=j/20;
    Handle (Sample2D_Text) aText  = 
        new Sample2D_Text(Text,
                       0,15*(j-15),      //  anX  , anY 
                       Aspect_TOT_SOLID,//  aType  
                       20.0*PI180 ,            //  anAngle  
                       0.0 ,            //  aSlant  
                       color++,               //  aColorIndex  
                       0,               //  aFontIndex  
                       j/20,                //  aScale 
                       Standard_False,  // aIsUnderline
                       Standard_False,   // aIsZoomable
                       Graphic2d_TOA_LEFT); // aTypeOfAlignment
    myAISInteractiveContext2D->Display(aText,            // object
                                       Standard_False);  // Redraw
    if (color == my2DViewer->ColorMap()->Size()) color =1;
  }

  for (j=5;j<=10;j+=1)
  {
    TCollection_AsciiString Text("font 1 scale ");Text+=j/10;
    Handle (Sample2D_Text) aText  = 
        new Sample2D_Text(Text,
                       80,15*(j-5),  //  anX  , anY 
                       Aspect_TOT_SOLID,//  aType  
                       0.0 ,            //  anAngle  
                       0.0 ,            //  aSlant  
                       color++,         //  aColorIndex  
                       1,               //  aFontIndex  
                       j/10,                //  aScale 
                       Standard_True,  // aIsUnderline
                       Standard_True,   // aIsZoomable
                       Graphic2d_TOA_CENTER); // aTypeOfAlignment

    myAISInteractiveContext2D->Display(aText,            // object
                                       Standard_False);  // Redraw
    if (color == my2DViewer->ColorMap()->Size()) color =1;
  }
    
  for (j=5;j<=10;j+=1)
  {
    TCollection_AsciiString Text("font 2 scale ");Text+=j/10;
    Handle (Sample2D_Text) aText  = 
        new Sample2D_Text(Text,
                       140,15*(j-5),  //  anX  , anY 
                       Aspect_TOT_SOLID,//  aType  
                       0.0 ,            //  anAngle  
                       0.0 ,            //  aSlant  
                       color++,         //  aColorIndex  
                       2,               //  aFontIndex  
                       j/10,               //  aScale 
                       Standard_False,  // aIsUnderline
                       Standard_True,   // aIsZoomable
                       Graphic2d_TOA_TOPLEFT); // aTypeOfAlignment
    myAISInteractiveContext2D->Display(aText,            // object
                                       Standard_False);  // Redraw
    if (color == my2DViewer->ColorMap()->Size()) color =1;
  }
    
  for (j=10;j<=15;j+=1)
  {
    TCollection_AsciiString Text("font 3 scale ");Text+=j/10;
    Handle (Sample2D_Text) aText  = 
        new Sample2D_Text(Text,
                       260,15*(j-10),      //  anX  , anY 
                       Aspect_TOT_SOLID,//  aType  
                       0 ,            //  anAngle  
                       0.0 ,            //  aSlant  
                       color++,               //  aColorIndex  
                       3,               //  aFontIndex  
                       j/10,                //  aScale 
                       Standard_False,  // aIsUnderline
                       Standard_False,   // aIsZoomable
                       Graphic2d_TOA_LEFT); // aTypeOfAlignment
    myAISInteractiveContext2D->Display(aText,            // object
                                       Standard_False);  // Redraw
    if (color == my2DViewer->ColorMap()->Size()) color =1;
  }

  FitAll2DViews(Standard_True); // Update Viewer
  // Update Get information to update Result dialog
  UINT anID=ID_BUTTON_Test_Text;
  TCollection_AsciiString Message("  \
create a set of Sample2D_Text,display it and declare selectable :    \n\
------------------------------------------------------------------------------ \n\
    Handle (Sample2D_Text) aText;                          \n\
    // aText = new ...                                            \n\
   myAISInteractiveContext2D->Display(aText,            // object     \n\
                                      Standard_False);  // Redraw       \n\
------------------------------------------------------------------------------ \n\
   after that the system call the SetContext Method for the display,\n\
------------------------------------------------------------------------------ \n\
                                                                  \n\
void Sample2D_Text::SetContext(const Handle(AIS2D_InteractiveContext)& theContext) \n\
{ \n\
  AIS2D_InteractiveObject::SetContext(theContext); \n\
\n\
  Handle(Graphic2d_Text) text; \n\
  text = new Graphic2d_Text(this, myText, myX, myY, myAngle,myTypeOfText,myScale); \n\
  text->SetFontIndex  (myFontIndex); \n\
  text->SetColorIndex (myColorIndex); \n\
  text->SetSlant      (mySlant); \n\
  text->SetUnderline  (myIsUnderline); \n\
  text->SetZoomable   (myIsZoomable); \n\
  text->SetAlignment  (myTypeOfAlignment); \n\
}");

  // Update The Result Dialog
  UpdateResultDialog(anID,Message);
}


void C2DAttributesDoc::OnBUTTONTestMarkers() 
{
    {    // generic Markers
      Standard_Integer MaxIndex = my2DViewer->MarkMap()->Size();
      
	  for (int i=1;i<=MaxIndex;i++)
      {
        Standard_Integer EntryNumber =  (my2DViewer->MarkMap()->Entry(i)).Index () ;

        Handle (Sample2D_Markers) Marker  = 
          new Sample2D_Markers(EntryNumber, // generic marker index
                               10*i,0,// display point
                               5,5, // size
                               0); // angle in radian
        myAISInteractiveContext2D->Display(Marker,            // object
                                           Standard_False);  // Redraw

      }
      for (i=1;i<=MaxIndex;i++)
      {
        Standard_Integer EntryNumber =  (my2DViewer->MarkMap()->Entry(i)).Index () ;
        Handle (Sample2D_Markers) Marker  = 
          new Sample2D_Markers(EntryNumber, // generic marker index
                               10*i,10,// display point
                               5,5, // size
                               20*PI180); // angle in radian
        myAISInteractiveContext2D->Display(Marker,            // object
                                           Standard_False);  // Redraw
      }
    }

    
    {  // a Circle Marker 
      Handle (Sample2D_Markers) Marker  = 
        new Sample2D_Markers(10,20,// reference point
                             0,0, // display point
                             2); // radius
      myAISInteractiveContext2D->Display(Marker,            // object
                                         Standard_False);  // Redraw

    }
    
    {  // an ellips Marker 
      Handle (Sample2D_Markers) Marker  = 
        new Sample2D_Markers(20,20, // reference point
                             0,0,  // display point
                             3,2,    // major, minor radius
                             20*PI180); // angle
      myAISInteractiveContext2D->Display(Marker,            // object
                                         Standard_False);  // Redraw
    }

    {  // a polyline  Marker 

      Graphic2d_Array1OfVertex myListVertex(1,6);
      myListVertex(1)=Graphic2d_Vertex(0.,0.);
      myListVertex(2)=Graphic2d_Vertex(0.,5.);
      myListVertex(3)=Graphic2d_Vertex(10.,0.);
      myListVertex(4)=Graphic2d_Vertex(10.,5.);
      myListVertex(5)=Graphic2d_Vertex(20.,0.);
      myListVertex(6)=Graphic2d_Vertex(20.,5.);

      Handle (Sample2D_Markers) Marker  = 
        new Sample2D_Markers(30,20, // reference point
                             myListVertex); 
      myAISInteractiveContext2D->Display(Marker,            // object
                                         Standard_True);  // Redraw

    }

  FitAll2DViews(Standard_False); // Update Viewer
  // Update Get information to update Result dialog

  UINT anID=ID_BUTTON_Test_Markers;
  TCollection_AsciiString Message(" \
create a set of Sample2D_Markers and display it :\n\
---------------------------------------------------\n\
    {\n\
      Standard_Integer MaxIndex = my2DViewer->MarkMap()->Size();\n\
      for (int i=1;i<=MaxIndex;i++) {\n\
        Standard_Integer EntryNumber =  (my2DViewer->MarkMap()->Entry(10)).Index () ;\n\
        Handle (Sample2D_Markers) Marker  = \n\
          new Sample2D_Markers(EntryNumber, // generic marker index\n\
                               10*i,0,// display point\n\
                               5,5, // size\n\
                               0); // angle in radian\n\
        myAISInteractiveContext2D->Display(Marker,            // object\n\
                                           Standard_False);  // Redraw\n\
\n\
    }\n\
  //...\n\
\n\
   after that the system call the SetContext Methods :                    \n\
\n\
void Sample2D_Markers::SetContext(const Handle(AIS2D_InteractiveContext)& theContext)  \n\
{ \n\
 AIS2D_InteractiveObject::SetContext(theContext); \n\
 if (myCurrentTypeOfMarker == 2D_CTOM_Generic) \n\
   if ( myIndex == 0 ) {\n\
     Handle(Graphic2d_Marker) aMarker=  \n\
        new Graphic2d_Marker(this, \n\
        myXPosition ,myYPosition); \n\
   }\n\
   else {\n\
     Handle(Graphic2d_Marker) aMarker=  \n\
        new Graphic2d_Marker(this,myIndex, \n\
        myXPosition ,myYPosition, \n\
        myWidth,myHeight,myAngle); \n\
   }\n\
 \n\
 if (myCurrentTypeOfMarker == 2D_CTOM_Polyline) \n\
   Handle(Graphic2d_PolylineMarker) aMarker=  \n\
      new Graphic2d_PolylineMarker(this, \n\
      myXPosition,myYPosition, \n\
      myListVertex); \n\
 \n\
 if (myCurrentTypeOfMarker == 2D_CTOM_Circle) \n\
   Handle(Graphic2d_CircleMarker) aMarker=  \n\
      new Graphic2d_CircleMarker(this, \n\
      myXPosition,myYPosition, \n\
      myX ,myY,myRadius  ); \n\
 \n\
 if (myCurrentTypeOfMarker == 2D_CTOM_Ellips) \n\
   Handle(Graphic2d_EllipsMarker) aMarker=  \n\
      new Graphic2d_EllipsMarker(this, \n\
      myXPosition,myYPosition, \n\
      myX,myY, \n\
      myMajorRadius,myMinorRadius, \n\
      myAngle ); \n\
 \n\
} \n\n");
  // Update The Result Dialog
  UpdateResultDialog(anID,Message);
}


void C2DAttributesDoc::OnBUTTONTestLine() 
{
  //Handle(ISessionSample2D_Line) aLine = new ISessionSample2D_Line();
  Handle(Sample2D_Line) aLine = new Sample2D_Line();

//  myInteractiveContext2D->Display(aLine,           // object
//                                Standard_True);  // Redraw

  myAISInteractiveContext2D->Display(aLine,           // object
                                     Standard_True);  // Redraw

  FitAll2DViews(Standard_False); // Update Viewer
  // Update Get information to update Result dialog

  UINT anID=ID_BUTTON_Test_Line;
  TCollection_AsciiString Message(" \
create a Sample2D_Line and display it :    \n\
------------------------------------------------------------------------------ \n\
  Handle(Sample2D_Line) aLine = new Sample2D_Line();\n\
  myAISInteractiveContext2D->Display(aLine,           // object\n\
                                     Standard_True);  // Redraw\n\
  FitAll2DViews(Standard_False); // Update Viewer\n\
------------------------------------------------------------------------------ \n\
   after that the system call the SetContext Methods :                    \n\
------------------------------------------------------------------------------ \n\
void Sample2D_Line::SetContext(const Handle(AIS2D_InteractiveContext)& theContext) \n\
{\n\
  AIS2D_InteractiveObject::SetContext(theContext); \n\
\n\
  Handle(Prs2d_AspectLine) aLineAspect = new Prs2d_AspectLine;  \n\
  aLineAspect->SetTypeOfFill(Graphic2d_TOPF_FILLED); \n\
  aLineAspect->SetWidthIndex(0); \n\
\n\
 for (int i=0;i<=13;i++)\n\
  for (int j=0;j<=5;j++)\n\
  {\n\
   {\n\
    Graphic2d_Array1OfVertex anArrayVertex(1,5);\n\
    anArrayVertex(1)=Graphic2d_Vertex(20.*i,10.*j+0);\n\
    anArrayVertex(2)=Graphic2d_Vertex(20.*i+10,10.*j+0);\n\
    anArrayVertex(3)=Graphic2d_Vertex(20.*i+10,10.*j+5);\n\
    anArrayVertex(4)=Graphic2d_Vertex(20.*i,10.*j+5);\n\
    anArrayVertex(5)=Graphic2d_Vertex(20.*i,10.*j+0);\n\
    Handle(Graphic2d_Polyline) aPolyline = \n\
        new Graphic2d_Polyline(this,anArrayVertex);\n\
\n\
    SetAspect(aLineAspect, aPolyline); \n\
\n\
    aPolyline->SetInteriorColorIndex(i); // to use with Graphic2d_TOPF_FILLED \n\
    aPolyline->SetTypeIndex(j);          // type of the polyline \n\
   }\n\
 }\n}");

  // Update The Result Dialog
  UpdateResultDialog(anID,Message);
}




