// File:        XmlMDataStd_GeometryDriver.cxx
// Created:     Fri Aug 24 20:46:58 2001
// Author:      Alexnder GRIGORIEV
// Copyright:   Open Cascade 2001
// History:

#include <XmlMDataStd_GeometryDriver.ixx>
#include <TDataStd_Geometry.hxx>

static const XmlObjMgt_DOMString& GeometryTypeString
                                        (const TDataStd_GeometryEnum);
static Standard_Boolean           GeometryTypeEnum
                                        (const XmlObjMgt_DOMString& theString,
                                         TDataStd_GeometryEnum&     theResult);

IMPLEMENT_DOMSTRING (TypeString,        "geomtype")

IMPLEMENT_DOMSTRING (GeomAnyString,     "any")
IMPLEMENT_DOMSTRING (GeomPointString,   "point")
IMPLEMENT_DOMSTRING (GeomLineString,    "line")
IMPLEMENT_DOMSTRING (GeomCircleString,  "circle")
IMPLEMENT_DOMSTRING (GeomEllipseString, "ellipse")

//=======================================================================
//function : XmlMDataStd_GeometryDriver
//purpose  : Constructor
//=======================================================================
XmlMDataStd_GeometryDriver::XmlMDataStd_GeometryDriver
                        (const Handle(CDM_MessageDriver)& theMsgDriver)
      : XmlMDF_ADriver (theMsgDriver, NULL)
{}

//=======================================================================
//function : NewEmpty
//purpose  : 
//=======================================================================
Handle(TDF_Attribute) XmlMDataStd_GeometryDriver::NewEmpty() const
{
  return (new TDataStd_Geometry());
}

//=======================================================================
//function : Paste
//purpose  : 
//=======================================================================
Standard_Boolean XmlMDataStd_GeometryDriver::Paste
                                        (const XmlObjMgt_Persistent&  theSource,
                                         const Handle(TDF_Attribute)& theTarget,
                                         XmlObjMgt_RRelocationTable&  ) const
{
  Handle(TDataStd_Geometry) aT = 
    Handle(TDataStd_Geometry)::DownCast (theTarget);

  XmlObjMgt_DOMString aType = theSource.Element().getAttribute(::TypeString());
  TDataStd_GeometryEnum aTypeEnum;
  if (GeometryTypeEnum (aType, aTypeEnum) == Standard_False) {
    WriteMessage ("TDataStd_GeometryEnum; "
                  "string value without enum term equivalence");
    return Standard_False;
  }

  aT->SetType (aTypeEnum);
  return Standard_True;
}

//=======================================================================
//function : Paste
//purpose  : 
//=======================================================================
void XmlMDataStd_GeometryDriver::Paste (const Handle(TDF_Attribute)& theSource,
                                        XmlObjMgt_Persistent&        theTarget,
                                        XmlObjMgt_SRelocationTable&  ) const
{
  Handle(TDataStd_Geometry) aG = Handle(TDataStd_Geometry)::DownCast(theSource);
  theTarget.Element().setAttribute (::TypeString(),
                                    GeometryTypeString (aG->GetType()));
}

//=======================================================================
//function : GeometryTypeEnum
//purpose  : 
//=======================================================================
static Standard_Boolean GeometryTypeEnum (const XmlObjMgt_DOMString& theString,
                                          TDataStd_GeometryEnum&     theResult) 
{
  TDataStd_GeometryEnum aResult = TDataStd_ANY_GEOM;
  if (!theString.equals (::GeomAnyString()))
  {
    if (theString.equals (::GeomPointString()))
      aResult = TDataStd_POINT;
    else if (theString.equals (::GeomLineString()))
      aResult = TDataStd_LINE;
    else if (theString.equals (::GeomCircleString()))
      aResult = TDataStd_CIRCLE;
    else if (theString.equals (::GeomEllipseString()))
      aResult = TDataStd_ELLIPSE;
    else
      return Standard_False;
  }
  theResult = aResult;
  return Standard_True;
}

//=======================================================================
//function : GeometryTypeString
//purpose  : 
//=======================================================================
static const XmlObjMgt_DOMString& GeometryTypeString
                                        (const TDataStd_GeometryEnum theE) 
{
  switch (theE)
  {
  case TDataStd_ANY_GEOM : return ::GeomAnyString();
  case TDataStd_POINT    : return ::GeomPointString();
  case TDataStd_LINE     : return ::GeomLineString();
  case TDataStd_CIRCLE   : return ::GeomCircleString();
  case TDataStd_ELLIPSE  : return ::GeomEllipseString();
    
  default:
    Standard_DomainError::Raise("TDataStd_GeometryEnum; enum term unknown");
  }
  static XmlObjMgt_DOMString aNullString;
  return aNullString; // To avoid compilation error message.
}
