// File:	TopoDS_Shape.cxx
// Created:	Wed Mar 20 11:33:26 1991
// Author:	Remi Lequette
//		<rle@topsn2>
 
#include <TopoDS_Shape.ixx>

//=======================================================================
//function : TopoDS_Shape
//purpose  : Constructor Null Shape
//=======================================================================

TopoDS_Shape::TopoDS_Shape () 
: myOrient(TopAbs_EXTERNAL)
{
}

//=======================================================================
//function : IsSame
//purpose  : 
//=======================================================================

Standard_Boolean TopoDS_Shape::IsSame (const TopoDS_Shape& other) const
{
  if (IsPartner(other)) {
    if (Location() == other.Location()) return Standard_True;
  }
  return Standard_False;
}

//=======================================================================
//function : IsEqual
//purpose  : 
//=======================================================================

Standard_Boolean TopoDS_Shape::IsEqual (const TopoDS_Shape& other) const
{
  if (IsPartner(other)) {
    if (Location() == other.Location()) {
      if (myOrient == other.myOrient) return Standard_True;
    }
  }
  return Standard_False;
}

//=======================================================================
//function : IsNotEqual
//purpose  : 
//=======================================================================

Standard_Boolean TopoDS_Shape::IsNotEqual (const TopoDS_Shape& other) const
{
  if (myOrient != other.myOrient)                 return Standard_True;
  if (!Location().IsEqual(other.Location())) return Standard_True;
  return !IsPartner(other);
}

//=======================================================================
//function : HashCode
//purpose  : 
//=======================================================================

Standard_Integer TopoDS_Shape::HashCode(const Standard_Integer Upper) const
{
  return 
    ((myTShape->HashCode(Upper)) ^ 
     (myLocation.HashCode(Upper))) % Upper;
} 
