// File:	StepToGeom_MakeTrimmedCurve2d.cxx
// Created:	Fri Nov  4 10:30:12 1994
// Author:	Frederic MAUPAS
//		<fma@bibox>
//:p0 abv 19.02.99: management of 'done' flag improved
//:p3 abv 23.02.99: bm4_id_punch_d.stp #1313: shift of parameters on ellipse with R1 < R2

#include <StepToGeom_MakeTrimmedCurve2d.ixx>
#include <StdFail_NotDone.hxx>
#include <gp_Pnt2d.hxx>
#include <Geom2dConvert.hxx>
#include <Geom2d_CartesianPoint.hxx>
#include <Geom2d_Curve.hxx>
#include <Geom2d_TrimmedCurve.hxx>
#include <Geom2d_BSplineCurve.hxx>
#include <StepGeom_CartesianPoint.hxx>
#include <StepGeom_Line.hxx>
#include <StepGeom_Vector.hxx>
#include <StepGeom_Circle.hxx>
#include <StepGeom_Ellipse.hxx>
#include <StepGeom_Parabola.hxx>
#include <StepGeom_Hyperbola.hxx>
#include <StepGeom_TrimmingSelect.hxx>
#include <StepGeom_HArray1OfTrimmingSelect.hxx>
#include <StepGeom_TrimmedCurve.hxx>
#include <StepToGeom_MakeTrimmedCurve2d.hxx>
#include <StepToGeom_MakeCartesianPoint2d.hxx>
#include <StepToGeom_MakeCurve2d.hxx>

#include <UnitsMethods.hxx>

//=============================================================================
// Creation d'une Trimmed Curve de Geom2d a partir d' une Trimmed Curve de Step
//=============================================================================
// Shall be completed to treat trimming with points

StepToGeom_MakeTrimmedCurve2d::StepToGeom_MakeTrimmedCurve2d 
(const Handle(StepGeom_TrimmedCurve)& TC)
{
  done = Standard_False;

  Handle(StepGeom_Curve) BasisCurve = TC->BasisCurve();
  StepToGeom_MakeCurve2d MkCurve2d(BasisCurve);
  if ( ! MkCurve2d.IsDone() ) return;
  Handle(Geom2d_Curve) theGeomBasis = MkCurve2d.Value();
  
  if (theGeomBasis->IsKind(STANDARD_TYPE(Geom2d_BSplineCurve))) {
    Handle(Geom2d_BSplineCurve) theResult = 
      Handle(Geom2d_BSplineCurve)::DownCast(theGeomBasis);
    theTrimmedCurve = theResult;
    done = Standard_True;
    return;
  }

  Handle(StepGeom_HArray1OfTrimmingSelect) theTrimSel1 = TC->Trim1();
  Handle(StepGeom_HArray1OfTrimmingSelect) theTrimSel2 = TC->Trim2();
  Standard_Integer nbSel1 = TC->NbTrim1();
  Standard_Integer nbSel2 = TC->NbTrim2();
  if ((nbSel1 == nbSel2 == 1) &&
      (theTrimSel1->Value(1).CaseMember() > 0) &&
      (theTrimSel2->Value(1).CaseMember() > 0)) {

    Standard_Real u1   = theTrimSel1->Value(1).ParameterValue();
    Standard_Real u2   = theTrimSel2->Value(1).ParameterValue();
    Standard_Real fact = 1., shift = 0.;

    if (BasisCurve->IsKind(STANDARD_TYPE(StepGeom_Line))) {
      Handle(StepGeom_Line)   theLine = Handle(StepGeom_Line)::DownCast(BasisCurve);
      Handle(StepGeom_Vector) vec = theLine->Dir();
      fact = vec->Magnitude();
    }
    else if (BasisCurve->IsKind(STANDARD_TYPE(StepGeom_Circle)) ||
	     BasisCurve->IsKind(STANDARD_TYPE(StepGeom_Ellipse))) {
//      if (u1 > 2.1*PI || u2 > 2.1*PI) fact = PI / 180.;
      fact = UnitsMethods::PlaneAngleFactor();
      //:p3 abv 23 Feb 99: shift on pi/2 on ellipse with R1 < R2
      Handle(StepGeom_Ellipse) ellipse = Handle(StepGeom_Ellipse)::DownCast(BasisCurve);
      if ( ! ellipse.IsNull() && 
	  ellipse->SemiAxis1() - ellipse->SemiAxis2() < 0. ) 
	shift = PI/2.;
    }
    else if (BasisCurve->IsKind(STANDARD_TYPE(StepGeom_Parabola)) ||
	     BasisCurve->IsKind(STANDARD_TYPE(StepGeom_Hyperbola))) {
      // LATER !!!
    }
//    CKY 16-DEC-1997 : USA60035 le texte de Part42 parle de degres
//      mais des systemes ecrivent en radians. Exploiter UnitsMethods

    Standard_Real newU1 = shift + u1 * fact;
    Standard_Real newU2 = shift + u2 * fact;

    Handle(Geom2d_TrimmedCurve) theTrimmed = 
      new Geom2d_TrimmedCurve(theGeomBasis,
			      newU1, newU2,
			      TC->SenseAgreement());
    Handle(Geom2d_BSplineCurve) theBSpline =
      Geom2dConvert::CurveToBSplineCurve(theTrimmed);
    theTrimmedCurve = theBSpline;  
    done = Standard_True;
  }
#ifdef DEB
  else cout << "Warning: TrimmedCurve2d not translated" << endl;
#endif
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom2d_BSplineCurve) &
      StepToGeom_MakeTrimmedCurve2d::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theTrimmedCurve;
}
