// File:	StepToGeom_MakeParabola.cxx
// Created:	Thu Sep  8 09:00:36 1994
// Author:	Frederic MAUPAS
//		<fma@nonox>


#include <StepToGeom_MakeParabola.ixx>
#include <StepGeom_Parabola.hxx>
#include <StepGeom_Axis2Placement3d.hxx>
#include <Geom_Axis2Placement.hxx>
#include <StepToGeom_MakeAxis2Placement.hxx>
#include <gp_Ax2.hxx>
#include <StdFail_NotDone.hxx>
#include <UnitsMethods.hxx>

//=============================================================================
// Creation d' un Parabola de Geom a partir d' un Parabola de Step
//=============================================================================

StepToGeom_MakeParabola::StepToGeom_MakeParabola
  ( const Handle(StepGeom_Parabola)& C)
{
  StepGeom_Axis2Placement   AxisSelect;
  Handle(StepGeom_Axis2Placement3d) A;
  Handle(Geom_Axis2Placement)    A1;
  gp_Ax2                         A2;
  Standard_Real                  focal;

  AxisSelect  = C->Position();
  if (AxisSelect.CaseNum(AxisSelect.Value()) == 2) {
    StepToGeom_MakeAxis2Placement
      MkAxis2(Handle(StepGeom_Axis2Placement3d)::DownCast(AxisSelect.Value()));
    A1 = MkAxis2.Value();
    A2 = A1->Ax2();
    focal = C->FocalDist() * UnitsMethods::LengthFactor();
    theParabola = new Geom_Parabola(A2, focal);
    done = Standard_True;
  }
  else {
    done= Standard_False;
  }
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom_Parabola) &
      StepToGeom_MakeParabola::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theParabola;
}
