// File:	StepToGeom_MakeConicalSurface.cxx
// Created:	Fri Jul  2 16:54:36 1993
// Author:	Martine LANGLOIS
//		<mla@mastox>

#include <StepToGeom_MakeConicalSurface.ixx>
#include <Geom_ConicalSurface.hxx>
#include <StepGeom_Axis2Placement3d.hxx>
#include <StepToGeom_MakeAxis2Placement.hxx>
#include <Geom_Axis2Placement.hxx>
#include <gp_Ax2.hxx>
#include <Precision.hxx>//#2(K3-3) rln
#include <StdFail_NotDone.hxx>
#include <UnitsMethods.hxx>

//=============================================================================
// Creation d' une ConicalSurface de Geom a partir d' une ConicalSurface de
// Step
//=============================================================================

StepToGeom_MakeConicalSurface::StepToGeom_MakeConicalSurface
  ( const Handle(StepGeom_ConicalSurface)& S)
{
  Standard_Real                         R, Ang;
  Handle(StepGeom_Axis2Placement3d) A;
  Handle(Geom_Axis2Placement)           A1;
  gp_Ax2                                A2;

  R   = S->Radius() * UnitsMethods::LengthFactor();
  Ang = Max (S->SemiAngle() * UnitsMethods::PlaneAngleFactor(), Precision::Angular());//#2(K3-3) rln 12/02/98 ProSTEP ct_turbine-A.stp entity #518, #3571 (gp::Resolution() is too little)
  A   = S->Position();
  StepToGeom_MakeAxis2Placement MkAxis2(A);
  A1  = MkAxis2.Value();
  A2  = A1->Ax2();
  theConicalSurface = new Geom_ConicalSurface(A2, Ang, R);
  done = Standard_True;
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom_ConicalSurface) &
      StepToGeom_MakeConicalSurface::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theConicalSurface;
}
