/***********************************************************************

     FONCTION :
     ----------
        File OpenGl_togl_project_raster :
 

     REMARQUES:
     ---------- 
      

     HISTORIQUE DES MODIFICATIONS   :
     --------------------------------
       24-05-96 : CAL ; Creation
       12-06-98 : CAL ; Modification respecter l'origine top-left.

************************************************************************/

/*----------------------------------------------------------------------*/
/*
 * Includes
 */
#include <OpenGl_tgl_all.h>
#include <OpenGl_telem_util.h>
#include <OpenGl_cmn_varargs.h>
#include <OpenGl_tsm_ws.h>

int EXPORT
call_togl_project_raster
(
	int wsid,
	float x,
	float y,
	float z,
	int *ixr,
	int *iyr
)
{
TStatus result;
float xr, yr;

    Tint h;
    CMN_KEY_DATA key;

    TsmGetWSAttri (wsid, WSHeight, &key);
    h = key.ldata;

	result = TelProjectionRaster (wsid, x, y, z, &xr, &yr);

	if (result == TSuccess) {
		*ixr = (int) xr;
		*iyr = h - (int) yr;
		return (0);
	}
	else
		return (1);
}
