// File:        BinMDataStd_GeometryDriver.cxx
// Created:     Fri Aug 24 20:46:58 2001
// Author:      Alexnder GRIGORIEV
// Copyright:   Open Cascade 2001
// History:

#include <BinMDataStd_GeometryDriver.ixx>
#include <TDataStd_Geometry.hxx>

//=======================================================================
//function : BinMDataStd_GeometryDriver
//purpose  : Constructor
//=======================================================================
BinMDataStd_GeometryDriver::BinMDataStd_GeometryDriver
                        (const Handle(CDM_MessageDriver)& theMsgDriver)
      : BinMDF_ADriver (theMsgDriver, NULL)
{}

//=======================================================================
//function : NewEmpty
//purpose  : 
//=======================================================================
Handle(TDF_Attribute) BinMDataStd_GeometryDriver::NewEmpty() const
{
  return (new TDataStd_Geometry());
}

//=======================================================================
//function : Paste
//purpose  : P -> T
//=======================================================================
Standard_Boolean BinMDataStd_GeometryDriver::Paste
                                        (const BinObjMgt_Persistent&  theSource,
                                         const Handle(TDF_Attribute)& theTarget,
                                         BinObjMgt_RRelocationTable&  ) const
{
  Handle(TDataStd_Geometry) aT = 
    Handle(TDataStd_Geometry)::DownCast (theTarget);

  Standard_Integer aType;
  Standard_Boolean ok = theSource >> aType;
  if (ok)
    aT->SetType ((TDataStd_GeometryEnum) aType);

  return ok;
}

//=======================================================================
//function : Paste
//purpose  : T -> P
//=======================================================================
void BinMDataStd_GeometryDriver::Paste (const Handle(TDF_Attribute)& theSource,
                                        BinObjMgt_Persistent&        theTarget,
                                        BinObjMgt_SRelocationTable&  ) const
{
  Handle(TDataStd_Geometry) aG = Handle(TDataStd_Geometry)::DownCast(theSource);
  theTarget << (Standard_Integer) aG->GetType();
}
