// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _math_Crout_HeaderFile
#define _math_Crout_HeaderFile

#ifndef _math_Matrix_HeaderFile
#include <math_Matrix.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class StdFail_NotDone;
class math_NotSquare;
class Standard_DimensionError;
class math_Matrix;
class math_Vector;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class implements the Crout algorithm used to solve a <br>
//!          system A*X = B where A is a symmetric matrix. It can be used to <br>
//!          invert a symmetric matrix. <br>
//!          This algorithm is similar to Gauss but is faster than Gauss. <br>
//!          Only the inferior triangle of A and the diagonal can be given. <br>
class math_Crout  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Given an input matrix A, this algorithm inverts A by the <br>
//!          Crout algorithm. The user can give only the inferior <br>
//!          triangle for the implementation. <br>
//!          A can be decomposed like this: <br>
//!          A = L * D * T(L) where L is triangular inferior and D is <br>
//!          diagonal. <br>
//!          If one element of A is less than MinPivot, A is <br>
//!          considered as singular. <br>
//!          Exception NotSquare is raised if A is not a square matrix. <br>
Standard_EXPORT math_Crout(const math_Matrix& A,const Standard_Real MinPivot = 1.0e-20);
//! Returns True if all has been correctly done. <br>
  Standard_Boolean IsDone() const;

//! Given an input vector <B>, this routine returns the <br>
//!          solution of the set of linear equations A . X = B. <br>
//!          Exception NotDone is raised if the decomposition was not <br>
//!          done successfully. <br>
//!          Exception DimensionError is raised if the range of B is <br>
//!          not equal to the rowrange of A. <br>
Standard_EXPORT   void Solve(const math_Vector& B,math_Vector& X) const;
//! returns the inverse matrix of A. Only the inferior <br>
//!          triangle is returned. <br>
//!          Exception NotDone is raised if NotDone. <br>
 const math_Matrix& Inverse() const;
//! returns in Inv the inverse matrix of A. Only the inferior <br>
//!          triangle is returned. <br>
//!          Exception NotDone is raised if NotDone. <br>
  void Invert(math_Matrix& Inv) const;
//! Returns the value of the determinant of the previously LU <br>
//! decomposed matrix A. Zero is returned if the matrix A is considered as singular. <br>
//! Exceptions <br>
//! StdFail_NotDone if the algorithm fails (and IsDone returns false). <br>
  Standard_Real Determinant() const;

//! Prints on the stream o information on the current state <br>
//!          of the object. <br>
Standard_EXPORT   void Dump(Standard_OStream& o) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
math_Matrix InvA;
Standard_Boolean Done;
Standard_Real Det;


};


#include <math_Crout.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
