// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Visual3d_ViewMapping_HeaderFile
#define _Visual3d_ViewMapping_HeaderFile

#ifndef _Graphic3d_Vertex_HeaderFile
#include <Graphic3d_Vertex.hxx>
#endif
#ifndef _Visual3d_TypeOfProjection_HeaderFile
#include <Visual3d_TypeOfProjection.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_TColStd_HArray2OfReal_HeaderFile
#include <Handle_TColStd_HArray2OfReal.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class TColStd_HArray2OfReal;
class Visual3d_ViewMappingDefinitionError;
class Visual3d_View;
class Graphic3d_Vertex;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class allows the definition of a projection and <br>
//!	    a system of coordinates called NPC. <br>
//!	    (Normalized Projection Coordinates). <br>
//!	    The projection can be parallel or perspective. <br>
//!  References: The definitions are Phigs oriented. <br>
//!  Keywords: View, Mapping, Window, View Plane, Front Plane, <br>
//!    BackPlane, Projection Type, Reset, Projection <br>
//! Summary of 3D View Mapping                   -- <br>
//! The view mapping transformation  defines the -- <br>
//! window-to-viewport mapping of View Reference -- <br>
//! Coordinates (VRC)  to Normalized  Projection -- <br>
//! Coordinates (NPC).                           -- <br>
//! CAS.CADE supports two kinds of projection :  -- <br>
//! 	Parallel :                              -- <br>
//!	The Projection Reference Point (PRP)    -- <br>
//!	determines the direction of projection. -- <br>
//! 	Perspective :                           -- <br>
//!	The projector lines converge at the     -- <br>
//!	Projection Reference Point (PRP).       -- <br>
//! To define a  view mapping transformation you -- <br>
//! must define :                                -- <br>
//!	The Projection Type                     -- <br>
//!	The Projection Reference Point (PRP)    -- <br>
//!	The Distance from Back Plane (BPD)      -- <br>
//!	The Distance from Front Plane (FPD)     -- <br>
//!	The Distance from View Plane (VPD)      -- <br>
//!	The Window in the View Plane.           -- <br>
class Visual3d_ViewMapping  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates a projection. <br>
Standard_EXPORT Visual3d_ViewMapping();

//! Creates a projection. <br>
Standard_EXPORT Visual3d_ViewMapping(const Visual3d_TypeOfProjection AType,const Graphic3d_Vertex& PRP,const Standard_Real BPD,const Standard_Real FPD,const Standard_Real VPD,const Standard_Real WUmin,const Standard_Real WVmin,const Standard_Real WUmax,const Standard_Real WVmax);

//! Modifies the back clipping plane. <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: Raises ViewMappingDefinitionError <br>
//!	    if <PRP> is between the front and back planes. <br>
//!	    if <PRP> is positioned on the view plane. <br>
//!	    if the back plane is in front of the front plane. <br>
Standard_EXPORT   void SetBackPlaneDistance(const Standard_Real BPD) ;

//! Modifies the front clipping plane. <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: Raises ViewMappingDefinitionError <br>
//!	    if <PRP> is between the front and back planes. <br>
//!	    if <PRP> is positioned on the view plane. <br>
//!	    if the back plane is in front of the front plane. <br>
Standard_EXPORT   void SetFrontPlaneDistance(const Standard_Real FPD) ;

//! Modifies the type of projection. <br>
Standard_EXPORT   void SetProjection(const Visual3d_TypeOfProjection AType) ;

//! Modifies the PRP. <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: Raises ViewMappingDefinitionError <br>
//!	    if <PRP> is between the front and back planes. <br>
//!	    if <PRP> is positioned on the view plane. <br>
Standard_EXPORT   void SetProjectionReferencePoint(const Graphic3d_Vertex& PRP) ;

//! Modifies the distance of the view plane of projection. <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: Raises ViewMappingDefinitionError <br>
//!	    if <PRP> is positioned on the view plane. <br>
Standard_EXPORT   void SetViewPlaneDistance(const Standard_Real VPD) ;

//! Modifies the visible part of the projection plane. <br>
//!  Category: Methods to modify the class definition <br>
//!  Warning: Raises ViewMappingDefinitionError if the <br>
//!	    specified window is invalid. <br>
Standard_EXPORT   void SetWindowLimit(const Standard_Real Umin,const Standard_Real Vmin,const Standard_Real Umax,const Standard_Real Vmax) ;

//! Sets custom PROJECTION matrix for the OpenGl context <br>
Standard_EXPORT   void SetCustomProjectionMatrix(const Handle(TColStd_HArray2OfReal)& Mat) ;

//! Returns the distance from the back clipping plane <br>
//! of this view mapping. <br>
Standard_EXPORT   Standard_Real BackPlaneDistance() const;

//! Returns the distance from the front clipping plane <br>
//! of this view mapping. <br>
Standard_EXPORT   Standard_Real FrontPlaneDistance() const;

//! Returns the type of projection. <br>
Standard_EXPORT   Visual3d_TypeOfProjection Projection() const;

//! Returns the PRP. <br>
Standard_EXPORT   Graphic3d_Vertex ProjectionReferencePoint() const;

//! Returns the distance from the projection plane. <br>
Standard_EXPORT   Standard_Real ViewPlaneDistance() const;

//! Returns the visible part of the projection plane. <br>
Standard_EXPORT   void WindowLimit(Standard_Real& Umin,Standard_Real& Vmin,Standard_Real& Umax,Standard_Real& Vmax) const;

//! Returns whether the custom PROJECTION matrix is used. <br>
Standard_EXPORT   Standard_Boolean IsCustomMatrix() const;


friend class Visual3d_View;



protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//! Copies the content of <Other> into <me>. <br>
Standard_EXPORT   void Assign(const Visual3d_ViewMapping& Other) ;


 // Fields PRIVATE
 //
Graphic3d_Vertex MyReferencePoint;
Visual3d_TypeOfProjection MyProjectionType;
Standard_Real MyBackPlaneDistance;
Standard_Real MyFrontPlaneDistance;
Standard_Real MyViewPlaneDistance;
Standard_Real MyWindowLimits[4];
Handle_TColStd_HArray2OfReal MyProjectionMatrix;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
