// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TopoDS_TShape_HeaderFile
#define _TopoDS_TShape_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_TopoDS_TShape_HeaderFile
#include <Handle_TopoDS_TShape.hxx>
#endif

#ifndef _TopoDS_ListOfShape_HeaderFile
#include <TopoDS_ListOfShape.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopAbs_ShapeEnum_HeaderFile
#include <TopAbs_ShapeEnum.hxx>
#endif
class Standard_ConstructionError;
class TopoDS_Iterator;
class TopoDS_Builder;
class TopoDS_ListOfShape;


//! A TShape  is a topological  structure describing a <br>
//!          set of points in a 2D or 3D space. <br>
//! <br>
//!          TShapes are   defined   by  their  optional domain <br>
//!          (geometry)  and  their  components  (other TShapes <br>
//!          with  Locations and Orientations).  The components <br>
//!          are stored in a List of Shapes. <br>
//! <br>
//!          A   TShape contains  the   following boolean flags : <br>
//! <br>
//!           - Free       : Free or Frozen. <br>
//!           - Modified   : Has been modified. <br>
//!           - Checked    : Has been checked. <br>
//!           - Orientable : Can be oriented. <br>
//!           - Closed     : Is closed. <br>
//!           - Infinite   : Is infinite. <br>
//!           - Convex     : Is convex. <br>
//! <br>
//! <br>
//!          Users have no direct access to the classes derived <br>
//!          from TShape.  They  handle them with   the classes <br>
//!          derived from Shape. <br>
class TopoDS_TShape : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Returns the free flag. <br>
Standard_EXPORT   Standard_Boolean Free() const;

//! Sets the free flag. <br>
Standard_EXPORT   void Free(const Standard_Boolean F) ;

//! Returns the modification flag. <br>
Standard_EXPORT   Standard_Boolean Modified() const;

//! Sets the modification flag. <br>
Standard_EXPORT   void Modified(const Standard_Boolean M) ;

//! Returns the checked flag. <br>
Standard_EXPORT   Standard_Boolean Checked() const;

//! Sets the checked flag. <br>
Standard_EXPORT   void Checked(const Standard_Boolean C) ;

//! Returns the orientability flag. <br>
Standard_EXPORT   Standard_Boolean Orientable() const;

//! Sets the orientability flag. <br>
Standard_EXPORT   void Orientable(const Standard_Boolean C) ;

//! Returns the closedness flag. <br>
Standard_EXPORT   Standard_Boolean Closed() const;

//! Sets the closedness flag. <br>
Standard_EXPORT   void Closed(const Standard_Boolean C) ;

//! Returns the infinity flag. <br>
Standard_EXPORT   Standard_Boolean Infinite() const;

//! Sets the infinity flag. <br>
Standard_EXPORT   void Infinite(const Standard_Boolean C) ;

//! Returns the convexness flag. <br>
Standard_EXPORT   Standard_Boolean Convex() const;

//! Sets the convexness flag. <br>
Standard_EXPORT   void Convex(const Standard_Boolean C) ;

//! Returns the type as a term of the ShapeEnum enum : <br>
//!          VERTEX, EDGE, WIRE, FACE, .... <br>
Standard_EXPORT virtual  TopAbs_ShapeEnum ShapeType() const = 0;

//! Returns a copy  of the  TShape  with no sub-shapes. <br>
Standard_EXPORT virtual  Handle_TopoDS_TShape EmptyCopy() const = 0;
//Standard_EXPORT ~TopoDS_TShape();


friend class TopoDS_Iterator;
friend class TopoDS_Builder;


 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 

//! Constructs an empty TShape. <br>
//!          Free       : True <br>
//!          Modified   : True <br>
//!          Checked    : False <br>
//!          Orientable : True <br>
//!          Closed     : False <br>
//!          Infinite   : False <br>
//!          Convex     : False <br>
Standard_EXPORT TopoDS_TShape();


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

 const TopoDS_ListOfShape& Shapes() const;

  TopoDS_ListOfShape& ChangeShapes() ;


 // Fields PRIVATE
 //
TopoDS_ListOfShape myShapes;
Standard_Integer myFlags;


};


#include <TopoDS_TShape.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
