// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TopOpeBRep_VPointInterClassifier_HeaderFile
#define _TopOpeBRep_VPointInterClassifier_HeaderFile

#ifndef _BRepClass_FaceClassifier_HeaderFile
#include <BRepClass_FaceClassifier.hxx>
#endif
#ifndef _TopAbs_State_HeaderFile
#include <TopAbs_State.hxx>
#endif
#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class TopoDS_Shape;
class TopOpeBRep_VPointInter;
class TopOpeBRep_PointClassifier;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class TopOpeBRep_VPointInterClassifier  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT TopOpeBRep_VPointInterClassifier();

//! compute position of VPoint <VP> regarding with face <F>. <br>
//! <ShapeIndex> (= 1,2) indicates which (u,v) point of <VP> is used. <br>
//! when state is ON, set VP.EdgeON() with the edge containing <VP> <br>
//! and associated parameter. <br>
//! returns state of VP on ShapeIndex. <br>
Standard_EXPORT   TopAbs_State VPointPosition(const TopoDS_Shape& F,TopOpeBRep_VPointInter& VP,const Standard_Integer ShapeIndex,TopOpeBRep_PointClassifier& PC,const Standard_Boolean AssumeINON,const Standard_Real Tol) ;

//! returns the edge containing the VPoint <VP> used in the <br>
//! last VPointPosition() call. Edge is defined if the state previously <br>
//! computed is ON, else Edge is a null shape. <br>
Standard_EXPORT  const TopoDS_Shape& Edge() const;

//! returns the parameter of the VPoint <VP> on Edge() <br>
Standard_EXPORT   Standard_Real EdgeParameter() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
BRepClass_FaceClassifier mySlowFaceClassifier;
TopAbs_State myState;
TopoDS_Shape myNullShape;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
