// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Standard_AncestorIterator_HeaderFile
#define _Standard_AncestorIterator_HeaderFile

#ifndef _Handle_Standard_Type_HeaderFile
#include <Handle_Standard_Type.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Standard_Type;
class Standard_NoMoreObject;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//! The class <AncestorIterator> is a iterator which provides <br>
//! information about inheritance. <br>
//! An AncestorIterator object is used to scan sequentially the <br>
//! hierarchy of a type object from its direct super-type to the root. <br>
class Standard_AncestorIterator  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//!   The copy constructor for a AncestorIterator . <br>
//! <br>
Standard_EXPORT Standard_AncestorIterator(const Standard_AncestorIterator& anOther);


//!   Creates an iterator on the type <aType>. <br>
//!   Set the iterator at the beginning of the ancestors; <br>
//!   this means near parents are first. <br>
Standard_EXPORT Standard_AncestorIterator(const Handle(Standard_Type)& aType);


//!   Assigns an  AncestorIterator from another AncestorIterator. <br>
Standard_EXPORT   void Assign(const Standard_AncestorIterator& anOther) ;
  void operator =(const Standard_AncestorIterator& anOther) 
{
  Assign(anOther);
}



//! Returns True if there are other ancestors. <br>
Standard_EXPORT   Standard_Boolean More() const;


//! Moves the position of the iterator to the next super-type. <br>
//! If the current position corresponds to a root class, it becomes undefined. <br>
Standard_EXPORT   void Next() ;


//!   Returns an <AncestorIterator> corresponding to the current position <br>
//!   of the iterator. <br>
//! If there are no more Ancestors. <br>
Standard_EXPORT   Standard_AncestorIterator Iterator() const;


//! Returns the type corresponding to the current position of <br>
//! the iterator. <br>
Standard_EXPORT   Handle_Standard_Type Value() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Standard_Type myType;
Standard_Integer myNbIter;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
