// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ShapeUpgrade_SplitCurve_HeaderFile
#define _ShapeUpgrade_SplitCurve_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_ShapeUpgrade_SplitCurve_HeaderFile
#include <Handle_ShapeUpgrade_SplitCurve.hxx>
#endif

#ifndef _Handle_TColStd_HSequenceOfReal_HeaderFile
#include <Handle_TColStd_HSequenceOfReal.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _ShapeExtend_Status_HeaderFile
#include <ShapeExtend_Status.hxx>
#endif
class TColStd_HSequenceOfReal;


//! Splits a  curve with a  criterion. <br>
class ShapeUpgrade_SplitCurve : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Empty constructor. <br>
Standard_EXPORT ShapeUpgrade_SplitCurve();

//! Initializes with curve first and last parameters. <br>
Standard_EXPORT   void Init(const Standard_Real First,const Standard_Real Last) ;

//! Sets the parameters where splitting has to be done. <br>
Standard_EXPORT   void SetSplitValues(const Handle(TColStd_HSequenceOfReal)& SplitValues) ;

//! If Segment is True, the result is composed with <br>
//!  segments of the curve bounded by the SplitValues.  If <br>
//!  Segment is False, the result is composed with trimmed <br>
//!  Curves all based on the same complete curve. <br>
//! <br>
Standard_EXPORT virtual  void Build(const Standard_Boolean Segment) ;

//! returns all the splitting values including the <br>
//!  First and Last parameters of the input curve <br>//! Merges input split values and new ones into myGlobalKnots <br>
Standard_EXPORT  const Handle_TColStd_HSequenceOfReal& SplitValues() const;

//! Calculates points for correction/splitting of the curve <br>
Standard_EXPORT virtual  void Compute() ;

//! Performs correction/splitting of the curve. <br>
//!         First defines splitting values by method Compute(), then calls method Build(). <br>
Standard_EXPORT   void Perform(const Standard_Boolean Segment = Standard_True) ;

//! Returns the status <br>
//! OK    - no splitting is needed <br>
//! DONE1 - splitting required and gives more than one segment <br>
//! DONE2 - splitting is required, but gives only one segment (initial) <br>
//! DONE3 - geometric form of the curve or parametrisation is modified <br>
Standard_EXPORT   Standard_Boolean Status(const ShapeExtend_Status status) const;
//Standard_EXPORT ~ShapeUpgrade_SplitCurve();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
Handle_TColStd_HSequenceOfReal mySplitValues;
Standard_Integer myNbCurves;
Standard_Integer myStatus;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
