// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ShapeFix_Solid_HeaderFile
#define _ShapeFix_Solid_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_ShapeFix_Solid_HeaderFile
#include <Handle_ShapeFix_Solid.hxx>
#endif

#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _Handle_ShapeFix_Shell_HeaderFile
#include <Handle_ShapeFix_Shell.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _ShapeFix_Root_HeaderFile
#include <ShapeFix_Root.hxx>
#endif
#ifndef _ShapeExtend_Status_HeaderFile
#include <ShapeExtend_Status.hxx>
#endif
#ifndef _Handle_ShapeExtend_BasicMsgRegistrator_HeaderFile
#include <Handle_ShapeExtend_BasicMsgRegistrator.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class ShapeFix_Shell;
class TopoDS_Solid;
class TopoDS_Shell;
class TopoDS_Shape;
class ShapeExtend_BasicMsgRegistrator;


//! Provides method to build a solid from a shells and <br>
//!          orients them in order to have a valid solid with finite volume <br>
class ShapeFix_Solid : public ShapeFix_Root {

public:
 // Methods PUBLIC
 // 

//! Empty constructor; <br>
Standard_EXPORT ShapeFix_Solid();

//! Initializes by solid. <br>
Standard_EXPORT ShapeFix_Solid(const TopoDS_Solid& solid);

//! Initializes by solid . <br>
Standard_EXPORT virtual  void Init(const TopoDS_Solid& solid) ;

//! Iterates on shells and performs fixes <br>
//!          (calls ShapeFix_Shell for each subshell) <br>
Standard_EXPORT virtual  Standard_Boolean Perform() ;

//! Calls MakeSolid and orients the solid to be "not infinite" <br>
Standard_EXPORT   TopoDS_Solid SolidFromShell(const TopoDS_Shell& shell) ;

//! Returns the status of the last Fix. <br>
Standard_EXPORT   Standard_Boolean Status(const ShapeExtend_Status status) const;

//! Returns resulting solid. <br>
Standard_EXPORT   TopoDS_Shape Solid() const;
//! Returns tool for fixing shells. <br>
  Handle_ShapeFix_Shell FixShellTool() const;

//! Sets message registrator <br>
Standard_EXPORT virtual  void SetMsgRegistrator(const Handle(ShapeExtend_BasicMsgRegistrator)& msgreg) ;

//! Sets basic precision value (also to FixShellTool) <br>
Standard_EXPORT virtual  void SetPrecision(const Standard_Real preci) ;

//! Sets minimal allowed tolerance (also to FixShellTool) <br>
Standard_EXPORT virtual  void SetMinTolerance(const Standard_Real mintol) ;

//! Sets maximal allowed tolerance (also to FixShellTool) <br>
Standard_EXPORT virtual  void SetMaxTolerance(const Standard_Real maxtol) ;
//! Returns (modifiable) the mode for applying fixes of <br>
//!          ShapeFix_Shell, by default True. <br>
  Standard_Integer& FixShellMode() ;
//! Returns (modifiable) the mode for creation of solids. <br>
//!          If mode myCreateOpenSolidMode is equal to true <br>
//!          solids are created from open shells <br>
//!          else solids are created  from closed shells only. <br>
//!          ShapeFix_Shell, by default False. <br>
  Standard_Boolean& CreateOpenSolidMode() ;

//! In case of multiconnexity returns compound of fixed solids <br>
//!          else returns one solid. <br>
Standard_EXPORT   TopoDS_Shape Shape() ;
//Standard_EXPORT ~ShapeFix_Solid();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
TopoDS_Shape mySolid;
Handle_ShapeFix_Shell myFixShell;
Standard_Integer myStatus;
Standard_Integer myFixShellMode;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean myCreateOpenSolidMode;


};


#include <ShapeFix_Solid.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
