// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _LProp_CurAndInf_HeaderFile
#define _LProp_CurAndInf_HeaderFile

#ifndef _TColStd_SequenceOfReal_HeaderFile
#include <TColStd_SequenceOfReal.hxx>
#endif
#ifndef _LProp_SequenceOfCIType_HeaderFile
#include <LProp_SequenceOfCIType.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _LProp_CIType_HeaderFile
#include <LProp_CIType.hxx>
#endif
class Standard_OutOfRange;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Stores the parameters of a curve 2d or 3d corresponding <br>
//!          to the curvature's extremas and the Inflection's Points. <br>
class LProp_CurAndInf  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT LProp_CurAndInf();


Standard_EXPORT   void AddInflection(const Standard_Real Param) ;


Standard_EXPORT   void AddExtCur(const Standard_Real Param,const Standard_Boolean IsMin) ;


Standard_EXPORT   void Clear() ;


Standard_EXPORT   Standard_Boolean IsEmpty() const;

//! Returns the number of points. <br>
//!          The Points are stored to increasing parameter. <br>
Standard_EXPORT   Standard_Integer NbPoints() const;

//! Returns the parameter of the Nth point. <br>//! raises if N not in the range [1,NbPoints()] <br>
Standard_EXPORT   Standard_Real Parameter(const Standard_Integer N) const;

//! Returns <br>
//!          - MinCur if the Nth parameter corresponds to <br>
//!          a minimum of the radius of curvature. <br>
//!          - MaxCur if the Nth parameter corresponds to <br>
//!          a maximum of the radius of curvature. <br>
//!          - Inflection if the parameter corresponds to <br>
//!          a point of inflection. <br>//! raises if N not in the range [1,NbPoints()] <br>
Standard_EXPORT   LProp_CIType Type(const Standard_Integer N) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TColStd_SequenceOfReal theParams;
LProp_SequenceOfCIType theTypes;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
