// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESSolid_SphericalSurface_HeaderFile
#define _IGESSolid_SphericalSurface_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESSolid_SphericalSurface_HeaderFile
#include <Handle_IGESSolid_SphericalSurface.hxx>
#endif

#ifndef _Handle_IGESGeom_Point_HeaderFile
#include <Handle_IGESGeom_Point.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_IGESGeom_Direction_HeaderFile
#include <Handle_IGESGeom_Direction.hxx>
#endif
#ifndef _IGESData_IGESEntity_HeaderFile
#include <IGESData_IGESEntity.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class IGESGeom_Point;
class IGESGeom_Direction;
class gp_Pnt;


//! defines SphericalSurface, Type <196> Form Number <0,1> <br>
//!          in package IGESSolid <br>
//!          Spherical surface is defined by a center and radius. <br>
//!          In case of parametrised surface an axis and a <br>
//!          reference direction is provided. <br>
class IGESSolid_SphericalSurface : public IGESData_IGESEntity {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT IGESSolid_SphericalSurface();

//! This method is used to set the fields of the class <br>
//!           SphericalSurface <br>
//!       - aCenter : the coordinates of the center point <br>
//!       - aRadius : value of radius <br>
//!       - anAxis  : the direction of the axis <br>
//!                   Null in case of Unparametrised surface <br>
//!       - aRefdir : the reference direction <br>
//!                   Null in case of Unparametrised surface <br>
Standard_EXPORT   void Init(const Handle(IGESGeom_Point)& aCenter,const Standard_Real aRadius,const Handle(IGESGeom_Direction)& anAxis,const Handle(IGESGeom_Direction)& aRefdir) ;

//! returns the center of the spherical surface <br>
Standard_EXPORT   Handle_IGESGeom_Point Center() const;

//! returns the center of the spherical surface after applying <br>
//! TransformationMatrix <br>
Standard_EXPORT   gp_Pnt TransformedCenter() const;

//! returns the radius of the spherical surface <br>
Standard_EXPORT   Standard_Real Radius() const;

//! returns the direction of the axis (Parametrised surface) <br>
//! Null is returned if the surface is not parametrised <br>
Standard_EXPORT   Handle_IGESGeom_Direction Axis() const;

//! returns the reference direction (Parametrised surface) <br>
//! Null is returned if the surface is not parametrised <br>
Standard_EXPORT   Handle_IGESGeom_Direction ReferenceDir() const;

//! Returns True if the surface is parametrised, else False <br>
Standard_EXPORT   Standard_Boolean IsParametrised() const;
//Standard_EXPORT ~IGESSolid_SphericalSurface();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_IGESGeom_Point theCenter;
Standard_Real theRadius;
Handle_IGESGeom_Direction theAxis;
Handle_IGESGeom_Direction theRefDir;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
