// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IFSelect_SelectRootComps_HeaderFile
#define _IFSelect_SelectRootComps_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IFSelect_SelectRootComps_HeaderFile
#include <Handle_IFSelect_SelectRootComps.hxx>
#endif

#ifndef _IFSelect_SelectExtract_HeaderFile
#include <IFSelect_SelectExtract.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Handle_Interface_InterfaceModel_HeaderFile
#include <Handle_Interface_InterfaceModel.hxx>
#endif
class Interface_EntityIterator;
class Interface_Graph;
class Standard_Transient;
class Interface_InterfaceModel;
class TCollection_AsciiString;


//! A SelectRootComps sorts the Entities which are part of Strong <br>
//!           Componants, local roots of a set of Entities : they can be <br>
//!           Single Componants (containing one Entity) or Cycles <br>
//!           This class gives a more secure result than SelectRoots (which <br>
//!           considers only Single Componants) but is longer to work : it <br>
//!           can be used when there can be or there are cycles in a Model <br>
//!           For each cycle, one Entity is given arbitrarily <br>
//!           Reject works as for SelectRoots : Strong Componants defined in <br>
//!           the input list which are not local roots are given <br>
class IFSelect_SelectRootComps : public IFSelect_SelectExtract {

public:
 // Methods PUBLIC
 // 

//! Creates a SelectRootComps <br>
Standard_EXPORT IFSelect_SelectRootComps();

//! Returns the list of local root strong componants, by one <br>
//!           Entity par componant. It is redefined for a purpose of <br>
//!           effeciency : calling a Sort routine for each Entity would <br>
//!           cost more ressource than to work in once using a Map <br>
//!           RootResult takes in account the Direct status <br>
Standard_EXPORT virtual  Interface_EntityIterator RootResult(const Interface_Graph& G) const;

//! Returns always True, because RootResult has done work <br>
Standard_EXPORT   Standard_Boolean Sort(const Standard_Integer rank,const Handle(Standard_Transient)& ent,const Handle(Interface_InterfaceModel)& model) const;

//! Returns a text defining the criterium : "Local Root Componants" <br>
Standard_EXPORT   TCollection_AsciiString ExtractLabel() const;
//Standard_EXPORT ~IFSelect_SelectRootComps();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 

//! Returns True, RootResult assuring uniqueness <br>
Standard_EXPORT virtual  Standard_Boolean HasUniqueResult() const;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
