// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IFSelect_DispPerSignature_HeaderFile
#define _IFSelect_DispPerSignature_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IFSelect_DispPerSignature_HeaderFile
#include <Handle_IFSelect_DispPerSignature.hxx>
#endif

#ifndef _Handle_IFSelect_SignCounter_HeaderFile
#include <Handle_IFSelect_SignCounter.hxx>
#endif
#ifndef _IFSelect_Dispatch_HeaderFile
#include <IFSelect_Dispatch.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class IFSelect_SignCounter;
class Interface_InterfaceError;
class TCollection_AsciiString;
class Interface_Graph;
class IFGraph_SubPartsIterator;


//! A DispPerSignature sorts input Entities according to a <br>
//!           Signature : it works with a SignCounter to do this. <br>
class IFSelect_DispPerSignature : public IFSelect_Dispatch {

public:
 // Methods PUBLIC
 // 

//! Creates a DispPerSignature with no SignCounter (by default, <br>
//!           produces only one packet) <br>
Standard_EXPORT IFSelect_DispPerSignature();

//! Returns the SignCounter used for splitting <br>
Standard_EXPORT   Handle_IFSelect_SignCounter SignCounter() const;

//! Sets a SignCounter for sort <br>
//!           Remark : it is set to record lists of entities, not only counts <br>
Standard_EXPORT   void SetSignCounter(const Handle(IFSelect_SignCounter)& sign) ;

//! Returns the name of the SignCounter, which caracterises the <br>
//!           sorting criterium for this Dispatch <br>
Standard_EXPORT   Standard_CString SignName() const;

//! Returns as Label, "One File per Signature <name>" <br>
Standard_EXPORT   TCollection_AsciiString Label() const;

//! Returns True, maximum count is given as <nbent> <br>
Standard_EXPORT virtual  Standard_Boolean LimitedMax(const Standard_Integer nbent,Standard_Integer& max) const;

//! Computes the list of produced Packets. It defines Packets from <br>
//!           the SignCounter, which sirts the input Entities per Signature <br>
//!           (specific of the SignCounter). <br>
Standard_EXPORT   void Packets(const Interface_Graph& G,IFGraph_SubPartsIterator& packs) const;
//Standard_EXPORT ~IFSelect_DispPerSignature();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_IFSelect_SignCounter thesign;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
