// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IFGraph_AllConnected_HeaderFile
#define _IFGraph_AllConnected_HeaderFile

#ifndef _Interface_Graph_HeaderFile
#include <Interface_Graph.hxx>
#endif
#ifndef _Interface_GraphContent_HeaderFile
#include <Interface_GraphContent.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
class Interface_Graph;
class Standard_Transient;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! this class gives content of the CONNECTED COMPONANT(S) <br>
//!           which include specific Entity(ies) <br>
class IFGraph_AllConnected  : public Interface_GraphContent {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! creates an AllConnected from a graph, empty ready to be filled <br>
Standard_EXPORT IFGraph_AllConnected(const Interface_Graph& agraph);

//! creates an AllConnected which memorizes Entities Connected to <br>
//!           a given one, at any level : that is, itself, all Entities <br>
//!           Shared by it and Sharing it, and so on. <br>
//!           In other terms, this is the content of the CONNECTED COMPONANT <br>
//!           which include a specific Entity <br>
Standard_EXPORT IFGraph_AllConnected(const Interface_Graph& agraph,const Handle(Standard_Transient)& ent);

//! adds an entity and its Connected ones to the list (allows to <br>
//!           cumulate all Entities Connected by some ones) <br>
//!           Note that if "ent" is in the already computed list,, no entity <br>
//!           will be added, but if "ent" is not already in the list, a new <br>
//!           Connected Componant will be cumulated <br>
Standard_EXPORT   void GetFromEntity(const Handle(Standard_Transient)& ent) ;

//! Allows to restart on a new data set <br>
Standard_EXPORT   void ResetData() ;

//! does the specific evaluation (Connected entities atall levels) <br>
Standard_EXPORT virtual  void Evaluate() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Interface_Graph thegraph;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
