// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _HLRTest_HeaderFile
#define _HLRTest_HeaderFile

#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_HLRTopoBRep_OutLiner_HeaderFile
#include <Handle_HLRTopoBRep_OutLiner.hxx>
#endif
class HLRAlgo_Projector;
class TopoDS_Shape;
class HLRTopoBRep_OutLiner;
class Draw_Interpretor;
class HLRTest_ShapeData;
class HLRTest_DrawableEdgeTool;
class HLRTest_DrawablePolyEdgeTool;
class HLRTest_Projector;
class HLRTest_OutLiner;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This package   is  a test  of  the    Hidden Lines <br>
//!          algorithms instantiated on the BRep Data Structure <br>
//!          and using the Draw package to display the results. <br>
class HLRTest  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Set a Projector Variable <br>
Standard_EXPORT static  void Set(const Standard_CString Name,const HLRAlgo_Projector& P) ;

//! Get a projector variable <br>
//!          Returns false if the variable is not a projector <br>
Standard_EXPORT static  Standard_Boolean GetProjector(Standard_CString& Name,HLRAlgo_Projector& P) ;

//! Set a OutLiner Variable <br>
Standard_EXPORT static  void Set(const Standard_CString Name,const TopoDS_Shape& S) ;

//! Get a outliner variable <br>
//!          Returns a null handle if the variable is not a outliner <br>
Standard_EXPORT static  Handle_HLRTopoBRep_OutLiner GetOutLiner(Standard_CString& Name) ;

//! Defines commands to test the Hidden Line Removal <br>
Standard_EXPORT static  void Commands(Draw_Interpretor& I) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class HLRTest_ShapeData;
friend class HLRTest_DrawableEdgeTool;
friend class HLRTest_DrawablePolyEdgeTool;
friend class HLRTest_Projector;
friend class HLRTest_OutLiner;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
