// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GeomLib_Tool_HeaderFile
#define _GeomLib_Tool_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
class Geom_Curve;
class gp_Pnt;
class Geom_Surface;
class Geom2d_Curve;
class gp_Pnt2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//!   The methods of this class compute the parameter(s) of a given point on a <br>
//! curve or a surface. The point must be located either <br>
//! on the curve (surface) itself or relatively to the latter at <br>
//! a distance less than the tolerance value. <br>
//! Return FALSE if the point is beyond the tolerance <br>
//! limit or if computation fails. <br>
//! Max Tolerance value is currently limited to 1.e-4 for <br>
//! geometrical curves and 1.e-3 for BSpline, Bezier and <br>
//! other parametrical curves. <br>
class GeomLib_Tool  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Extracts the parameter of a 3D point lying on a 3D curve <br>
//! or at a distance less than the tolerance value. <br>
Standard_EXPORT static  Standard_Boolean Parameter(const Handle(Geom_Curve)& Curve,const gp_Pnt& Point,const Standard_Real Tolerance,Standard_Real& U) ;

//! Extracts the parameter of a 3D point lying on a surface <br>
//! or at a distance less than the tolerance value. <br>
Standard_EXPORT static  Standard_Boolean Parameters(const Handle(Geom_Surface)& Surface,const gp_Pnt& Point,const Standard_Real Tolerance,Standard_Real& U,Standard_Real& V) ;

//! Extracts the parameter of a 2D point lying on a 2D curve <br>
//! or at a distance less than the tolerance value. <br>
Standard_EXPORT static  Standard_Boolean Parameter(const Handle(Geom2d_Curve)& Curve,const gp_Pnt2d& Point,const Standard_Real Tolerance,Standard_Real& U) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
