// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepTools_Substitution_HeaderFile
#define _BRepTools_Substitution_HeaderFile

#ifndef _TopTools_DataMapOfShapeListOfShape_HeaderFile
#include <TopTools_DataMapOfShapeListOfShape.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Standard_NoSuchObject;
class TopoDS_Shape;
class TopTools_ListOfShape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! A tool to substitute subshapes by other shapes. <br>
//! <br>
//! <br>
//!          The user use the method Substitute to define the <br>
//!          modifications. <br>
//!          A set of shapes is designated to replace a initial <br>
//!          shape. <br>
class BRepTools_Substitution  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT BRepTools_Substitution();

//! Reset all the fields. <br>
Standard_EXPORT   void Clear() ;

//! <Oldshape> will be replaced by <NewShapes>. <br>
//! <br>
//!          <NewShapes> can be empty , in this case <OldShape> <br>
//!          will disparate from its ancestors. <br>
//! <br>
//!          if an item of <NewShapes> is oriented FORWARD. <br>
//!          it will be oriented as <OldShape> in its ancestors. <br>
//!          else it will be reversed. <br>
Standard_EXPORT   void Substitute(const TopoDS_Shape& OldShape,const TopTools_ListOfShape& NewShapes) ;

//! Build NewShape from <S> if its subshapes has modified. <br>
//! <br>
//!          The methods <IsCopied> and <Copy> allows you to keep <br>
//!          the resul of <Build> <br>
Standard_EXPORT   void Build(const TopoDS_Shape& S) ;

//! Returns   True if <S> has   been  replaced . <br>
Standard_EXPORT   Standard_Boolean IsCopied(const TopoDS_Shape& S) const;

//! Returns the set of shapes  substitued to <S> . <br>
Standard_EXPORT  const TopTools_ListOfShape& Copy(const TopoDS_Shape& S) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopTools_DataMapOfShapeListOfShape myMap;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
