// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepPrimAPI_MakeCone_HeaderFile
#define _BRepPrimAPI_MakeCone_HeaderFile

#ifndef _BRepPrim_Cone_HeaderFile
#include <BRepPrim_Cone.hxx>
#endif
#ifndef _BRepPrimAPI_MakeOneAxis_HeaderFile
#include <BRepPrimAPI_MakeOneAxis.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
class Standard_DomainError;
class gp_Ax2;
class BRepPrim_Cone;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Describes functions to build cones or portions of cones. <br>
//! A MakeCone object provides a framework for: <br>
//! -   defining the construction of a cone, <br>
//! -   implementing the construction algorithm, and <br>
//! -   consulting the result. <br>
class BRepPrimAPI_MakeCone  : public BRepPrimAPI_MakeOneAxis {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Make a cone of height H radius R1 in the plane z = <br>
//!          0, R2 in the plane Z = H. R1 and R2 may be null. <br>
Standard_EXPORT BRepPrimAPI_MakeCone(const Standard_Real R1,const Standard_Real R2,const Standard_Real H);

//! Make a cone of height H radius R1 in the plane z = <br>
//!          0, R2 in the plane Z = H. R1 and R2 may be null. <br>
//!          Take a section of <angle> <br>
Standard_EXPORT BRepPrimAPI_MakeCone(const Standard_Real R1,const Standard_Real R2,const Standard_Real H,const Standard_Real angle);

//! Make a cone of height H radius R1 in the plane z = <br>
//!          0, R2 in the plane Z = H. R1 and R2 may be null. <br>
Standard_EXPORT BRepPrimAPI_MakeCone(const gp_Ax2& Axes,const Standard_Real R1,const Standard_Real R2,const Standard_Real H);

//! Make a cone of height H radius R1 in the plane z = <br>
//!          0, R2 in the plane Z = H. R1 and R2 may be null. <br>
//!          Take a section of <angle> <br>//! Constructs a cone, or a portion of a cone, of height H, <br>
//! and radius R1 in the plane z = 0 and R2 in the plane <br>
//! z = H. The result is a sharp cone if R1 or R2 is equal to 0. <br>
//! The cone is constructed about the "Z Axis" of either: <br>
//! -   the global coordinate system, or <br>
//! -   the local coordinate system Axes. <br>
//! It is limited in these coordinate systems as follows: <br>
//! -   in the v parametric direction (the Z coordinate), by <br>
//!   the two parameter values 0 and H, <br>
//! -   and in the u parametric direction (defined by the <br>
//!   angle of rotation around the Z axis), in the case of a <br>
//!   portion of a cone, by the two parameter values 0 and <br>
//!   angle. Angle is given in radians. <br>
//! The resulting shape is composed of: <br>
//! -   a lateral conical face <br>
//! -   two planar faces in the planes z = 0 and z = H, <br>
//!   or only one planar face in one of these two planes if a <br>
//!   radius value is null (in the case of a complete cone, <br>
//!   these faces are circles), and <br>
//! -   and in the case of a portion of a cone, two planar <br>
//!   faces to close the shape. (either two parallelograms or <br>
//!   two triangles, in the planes u = 0 and u = angle). <br>
//! Exceptions <br>
//! Standard_DomainError if: <br>
//! -   H is less than or equal to Precision::Confusion(), or <br>
//! -   the half-angle at the apex of the cone, defined by <br>
//!   R1, R2 and H, is less than Precision::Confusion()/H, or greater than <br>
//!   (Pi/2)-Precision::Confusion()/H.f <br>
Standard_EXPORT BRepPrimAPI_MakeCone(const gp_Ax2& Axes,const Standard_Real R1,const Standard_Real R2,const Standard_Real H,const Standard_Real angle);

//! Returns the algorithm. <br>
Standard_EXPORT   Standard_Address OneAxis() ;

//! Returns the algorithm. <br>
//! <br>
Standard_EXPORT   BRepPrim_Cone& Cone() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
BRepPrim_Cone myCone;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
