// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepFill_ApproxSeewing_HeaderFile
#define _BRepFill_ApproxSeewing_HeaderFile

#ifndef _BRepFill_MultiLine_HeaderFile
#include <BRepFill_MultiLine.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
class Geom_Curve;
class Geom2d_Curve;
class StdFail_NotDone;
class BRepFill_MultiLine;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Evaluate the 3dCurve  and the PCurves described in <br>
//!          a MultiLine from BRepFill.  The parametrization of <br>
//!          those curves is  not  imposed by  the Bissectrice. <br>
//!          The  parametrization  is given  approximatively by <br>
//!          the abscissa of the curve3d. <br>
class BRepFill_ApproxSeewing  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT BRepFill_ApproxSeewing();


Standard_EXPORT BRepFill_ApproxSeewing(const BRepFill_MultiLine& ML);


Standard_EXPORT   void Perform(const BRepFill_MultiLine& ML) ;


Standard_EXPORT   Standard_Boolean IsDone() const;

//! returns the approximation of the 3d Curve <br>
Standard_EXPORT  const Handle_Geom_Curve& Curve() const;

//! returns the  approximation  of the  PCurve  on the <br>
//!          first face of the MultiLine <br>
Standard_EXPORT  const Handle_Geom2d_Curve& CurveOnF1() const;

//! returns the  approximation  of the  PCurve  on the <br>
//!          first face of the MultiLine <br>
Standard_EXPORT  const Handle_Geom2d_Curve& CurveOnF2() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
BRepFill_MultiLine myML;
Standard_Boolean myIsDone;
Handle_Geom_Curve myCurve;
Handle_Geom2d_Curve myPCurve1;
Handle_Geom2d_Curve myPCurve2;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
