// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepFeat_LocalOperation_HeaderFile
#define _BRepFeat_LocalOperation_HeaderFile

#ifndef _BRepFeat_Builder_HeaderFile
#include <BRepFeat_Builder.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class StdFail_NotDone;
class Standard_ConstructionError;
class TopoDS_Shape;
class TopTools_ListOfShape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! One of the most significant <br>
//! aspects of BRepFeat functionality is the use of local operations as <br>
//! opposed to global ones. In a global operation, you would first <br>
//! construct a form of the type you wanted in your final feature, and <br>
//! then remove matter so that it could fit into your initial basis <br>
//! object. In a local operation, however, you specify the domain <br>
//! of the feature construction with aspects of the shape on which the <br>
//! feature is being created. These semantics are expressed in terms <br>
//! of a member shape of the basis shape from which - or up to which <br>
//! - matter will be added or removed. As a result, local <br>
//! operations make calculations simpler and faster than global operations. <br>
//! In BRepFeat, the semantics of local operations define features <br>
//! constructed from a contour or a part of the basis shape referred to as the tool. <br>
class BRepFeat_LocalOperation  : public BRepFeat_Builder {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 
//! Builds the framework to store the topological shape <br>
//! which is to be created by the local operation. <br>
//! Initializes the empty constructor. <br>
BRepFeat_LocalOperation();
//! Builds the framework to store the topological shape <br>
//! which is to be created by the local operation. <br>
//! Initializes shape S for a local operation. <br>
//! The exception ConstructionError is raised if <S> is a null shape. <br>
BRepFeat_LocalOperation(const TopoDS_Shape& S);
//! Builds the framework to store the topological shape <br>
//! which is to be created by the local operation. <br>
//! Initializes S1 and S2 for a local operation. <br>
//! The exception ConstructionError is raised if <S> is a null shape. <br>
BRepFeat_LocalOperation(const TopoDS_Shape& S1,const TopoDS_Shape& S2);
//! Performs the local operation on the formerly given <br>
//!          shape,  with the tool <T>.  <L>  defines  a set of <br>
//!          faces  of  the shape.  The list  may not be empty. <br>
//!          The boolean <Fuse> gives the type of operation. If <br>
//!          set to  Standard_True, the operation  is a fusion. <br>
//!          If  set  to Standard_False,   the operation   is a <br>
//!          cutting one. <br>
//! <br>
//!          The Perform process stops just before constructing <br>
//!          any result in order to authorize  the selection of <br>
//!          parts of the tool.  After a call to Perform, it is <br>
//!          possible   to call     BuilPartsOfTool,       then <br>
//!          RemovePart/ActivatePart to select valid parts, and <br>
//!          it  is necessary to  call PerformResult to get any <br>
//!          result. <br>
  void Perform(const TopoDS_Shape& T,const TopTools_ListOfShape& L,const Standard_Boolean Fuse) ;
//! Performs the local operation on the formerly given <br>
//!          shape and tool.  <LShape>  defines a set  of faces <br>
//!          of the shape, <LTool> a set of  faces of the tool. <br>
//!          The boolean  <Fuse> gives the  type of  operation. <br>
//!          If  set  to   Standard_True,  the operation  is  a <br>
//!          fusion.   If  set to Standard_False, the operation <br>
//!          is a cutting one.  If <LShape> (resp.  <LTool>) is <br>
//!          empty, the whole shape (resp.  tool) is used. <br>
//! <br>
//!          The Perform process stops just before constructing <br>
//!          any result in  order to authorize the selection of <br>
//!          parts of the tool.  After a call to Perform, it is <br>
//!          possible     to   call     BuilPartsOfTool,   then <br>
//!          RemovePart/ActivatePart to select valid parts, and <br>
//!          it is necessary  to call PerformResult to  get any <br>
//!          result. <br>
  void Perform(const TopTools_ListOfShape& LShape,const TopTools_ListOfShape& LTool,const Standard_Boolean Fuse) ;
//! Constructs the primitive which serves as the tool for the <br>
//! feature construction. Gives faces concerned by the <br>
//! construction and builds by performing one of the <br>
//! Boolean operations on the two intersecting shapes. <br>
//!    Raises NotDone from StdFail if no call to Perform has been done. <br>
  void BuildPartsOfTool() ;
//! Returns  the list of  the  parts of tool.  Each of <br>
//!          these parts is a TopoDS_Shell. <br>
//! Raises NotDone  if no  call to BuildPartsOfTool has been done. <br>
 const TopTools_ListOfShape& PartsOfTool() const;
//! Removes <S> from the list of valid parts of tool. <br>
//! Raises NotDone  if no  call to BuildPartsOfTool has <br>
//! been done. <br>
  void RemovePart(const TopoDS_Shape& S) ;
//! By default, all tool parts are valid for the local operation. <br>
//!        This method removes <S>  from  the list  of  invalid parts  of <br>
//!          tool. By default, all parts  of tool are valid for <br>
//!          the local operation. <br>
  void ActivatePart(const TopoDS_Shape& S) ;

//! Builds the    resulting shape  (redefined     from <br>
//!          MakeShape). Invalidates the  given parts  of tools <br>
//!          if  any,   and performs the  result   of the local <br>
//!          operation. <br>
Standard_EXPORT virtual  void Build() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};


#include <BRepFeat_LocalOperation.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
