// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepBuilderAPI_FindPlane_HeaderFile
#define _BRepBuilderAPI_FindPlane_HeaderFile

#ifndef _Handle_Geom_Plane_HeaderFile
#include <Handle_Geom_Plane.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Geom_Plane;
class Standard_NoSuchObject;
class TopoDS_Shape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Describes functions to find the plane in which the edges <br>
//! of a given shape are located. <br>
//! A FindPlane object provides a framework for: <br>
//! -   extracting the edges of a given shape, <br>
//! -   implementing the construction algorithm, and <br>
//! -   consulting the result. <br>
class BRepBuilderAPI_FindPlane  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Initializes an empty algorithm. The function Init is then used to define the shape. <br>
Standard_EXPORT BRepBuilderAPI_FindPlane();

//!  Constructs the plane containing the edges of the shape S. <br>
//! A plane is built only if all the edges are within a distance <br>
//! of less than or equal to tolerance from a planar surface. <br>
//! This tolerance value is equal to the larger of the following two values: <br>
//! -   Tol, where the default value is negative, or <br>
//! -   the largest of the tolerance values assigned to the individual edges of S. <br>
//!   Use the function Found to verify that a plane is built. <br>
//! The resulting plane is then retrieved using the function Plane. <br>
Standard_EXPORT BRepBuilderAPI_FindPlane(const TopoDS_Shape& S,const Standard_Real Tol = -1);

//! Constructs the plane containing the edges of the shape S. <br>
//! A plane is built only if all the edges are within a distance <br>
//! of less than or equal to tolerance from a planar surface. <br>
//! This tolerance value is equal to the larger of the following two values: <br>
//! -   Tol, where the default value is negative, or <br>
//! -   the largest of the tolerance values assigned to the individual edges of S. <br>
//!   Use the function Found to verify that a plane is built. <br>
//! The resulting plane is then retrieved using the function Plane. <br>
Standard_EXPORT   void Init(const TopoDS_Shape& S,const Standard_Real Tol = -1) ;

//! Returns true if a plane containing the edges of the <br>
//! shape is found and built. Use the function Plane to consult the result. <br>
Standard_EXPORT   Standard_Boolean Found() const;

//! Returns the plane containing the edges of the shape. <br>
//! Warning <br>
//! Use the function Found to verify that the plane is built. If <br>
//! a plane is not found, Plane returns a null handle. <br>
Standard_EXPORT   Handle_Geom_Plane Plane() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Geom_Plane myPlane;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
