// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOP_SDFWESFiller_HeaderFile
#define _BOP_SDFWESFiller_HeaderFile

#ifndef _BOPTools_PDSFiller_HeaderFile
#include <BOPTools_PDSFiller.hxx>
#endif
#ifndef _BOP_Operation_HeaderFile
#include <BOP_Operation.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _BOP_PWireEdgeSet_HeaderFile
#include <BOP_PWireEdgeSet.hxx>
#endif
#ifndef _BOPTools_IndexedDataMapOfIntegerState_HeaderFile
#include <BOPTools_IndexedDataMapOfIntegerState.hxx>
#endif
class BOPTools_DSFiller;
class BOPTools_IndexedDataMapOfIntegerState;
class BOP_WireEdgeSet;
class TopoDS_Face;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//!  The  algorithm that fills a wire edges set (WES) <br>
//!  for a couple of faces that are same domain <br>
//! <br>
class BOP_SDFWESFiller  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Empty constructor <br>
Standard_EXPORT BOP_SDFWESFiller();


//! Constructor <br>
//! nF1, nF2 - indices of faces in the DataStructue (DS) <br>
Standard_EXPORT BOP_SDFWESFiller(const Standard_Integer nF1,const Standard_Integer nF2,const BOPTools_DSFiller& aDSF);


//! Modifier <br>
Standard_EXPORT   void SetStatesMap(const BOPTools_IndexedDataMapOfIntegerState& aStatesMap) ;


//! Modifier <br>
Standard_EXPORT   void SetFaces(const Standard_Integer nF1,const Standard_Integer nF2) ;


//! Modifier <br>
Standard_EXPORT   void SetDSFiller(const BOPTools_DSFiller& aDSF) ;


//! Modifier <br>
Standard_EXPORT   void SetOperation(const BOP_Operation anOp) ;


//! Modifier <br>
//! Assigns sensitivity flag for the faces in accordance <br>
//! with scalar product between theirs normalls <br>
//! 1  for same sense;  -1 for different sense <br>
Standard_EXPORT   void SetSenseFlag(const Standard_Integer aFlag) ;


//! Prepares data for the algorithm <br>
Standard_EXPORT   void Prepare() ;


//! Performs the algorithm <br>
Standard_EXPORT   void Do(const BOP_WireEdgeSet& aWES) ;


//! Selector <br>
Standard_EXPORT  const BOPTools_DSFiller& DSFiller() const;


//! Selector <br>
Standard_EXPORT  const BOPTools_IndexedDataMapOfIntegerState& StatesMap() const;


//! Selector <br>
Standard_EXPORT   void Faces(Standard_Integer& nF1,Standard_Integer& nF2) const;


//! Selector <br>
Standard_EXPORT   Standard_Integer SenseFlag() const;


//! Selector <br>
Standard_EXPORT   BOP_Operation Operation() const;


//! Update 3D-State for edges <br>
Standard_EXPORT   void UpdateDEStates3D() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


//! Assigns the 2D-State for split parts of <br>
//! the edges having 3D-Curves of given faces <br>
//! Internal  Purpose <br>
Standard_EXPORT   void AssignStates(const Standard_Integer nF1,const Standard_Integer nF2) ;


//! Prepares ON 2D parts to filled the WES <br>
//! Internal Purpose <br>
Standard_EXPORT   void PrepareOnParts() ;


//! Fills the WES by split parts of the edges for <br>
//! the Common Zone <br>
//! Internal Purpose <br>
Standard_EXPORT   void PrepareWESForZone(const Standard_Integer nF1,const Standard_Integer nF2) ;


//! Fills the WES by split parts of the edges for <br>
//! the Cut operation <br>
//! Internal Purpose <br>
//! <br>
Standard_EXPORT   void PrepareWESForCut(const Standard_Integer nF1,const Standard_Integer nF2) ;


//! Fills the WES by split parts (ON 2D) of the edges <br>
//! Internal Purpose <br>
Standard_EXPORT   void PrepareOnParts(const Standard_Integer nF1,const Standard_Integer nF2,const BOP_Operation Op) ;


//! Make orientation of the faces consistent <br>
//! Internal Purpose <br>
Standard_EXPORT   void PrepareFaces(const Standard_Integer nF1,const Standard_Integer nF2,TopoDS_Face& aF1,TopoDS_Face& aF2) const;


//! Assigns the 2D-State for split parts of <br>
//! the edges that do not have 3D-Curves of given faces <br>
//! Internal Purpose <br>
Standard_EXPORT   void AssignDEStates(const Standard_Integer nF1,const Standard_Integer nF2) ;


//! Assigns the 2D-State for split parts of <br>
//! the edge  nE1 that do not have 3D-Curves from face nF1 <br>
Standard_EXPORT   void AssignDEStates(const Standard_Integer nF1,const Standard_Integer nE1,const Standard_Integer nF2) ;


 // Fields PRIVATE
 //
BOPTools_PDSFiller myDSFiller;
BOP_Operation myOperation;
Standard_Integer myNF1;
Standard_Integer myNF2;
BOP_PWireEdgeSet myWES;
BOPTools_IndexedDataMapOfIntegerState myStatesMap;
Standard_Integer mySenseFlag;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
