// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOPTools_Curve_HeaderFile
#define _BOPTools_Curve_HeaderFile

#ifndef _IntTools_Curve_HeaderFile
#include <IntTools_Curve.hxx>
#endif
#ifndef _BOPTools_PaveSet_HeaderFile
#include <BOPTools_PaveSet.hxx>
#endif
#ifndef _BOPTools_ListOfPaveBlock_HeaderFile
#include <BOPTools_ListOfPaveBlock.hxx>
#endif
#ifndef _TColStd_ListOfInteger_HeaderFile
#include <TColStd_ListOfInteger.hxx>
#endif
class IntTools_Curve;
class BOPTools_PaveSet;
class BOPTools_PaveBlock;
class BOPTools_ListOfPaveBlock;
class TColStd_ListOfInteger;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//!  Class holds the  structure for storing information about <br>
//! intersection curve and set of paves on it <br>
//! <br>
class BOPTools_Curve  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Empty constructor <br>
Standard_EXPORT BOPTools_Curve();


//! Constructor <br>
Standard_EXPORT BOPTools_Curve(const IntTools_Curve& aIC);


//! Modifier <br>
Standard_EXPORT   void SetCurve(const IntTools_Curve& aIC) ;


//! Selector <br>
Standard_EXPORT  const IntTools_Curve& Curve() const;


//! Selector <br>
//! <br>
Standard_EXPORT   BOPTools_PaveSet& Set() ;


//! Adds the PaveBlock  <aPB> to the pave set <br>
Standard_EXPORT   void AppendNewBlock(const BOPTools_PaveBlock& aPB) ;


//! Returns the PaveBlock-s attached to the curve <br>
Standard_EXPORT  const BOPTools_ListOfPaveBlock& NewPaveBlocks() const;


//! Returns indices TechnoVertices attached to the curve <br>
Standard_EXPORT   TColStd_ListOfInteger& TechnoVertices() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
IntTools_Curve myCurve;
BOPTools_PaveSet myPaveSet;
BOPTools_ListOfPaveBlock myNewPBs;
TColStd_ListOfInteger myTechnoVertices;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
