// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Aspect_Edge_HeaderFile
#define _Aspect_Edge_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Aspect_TypeOfEdge_HeaderFile
#include <Aspect_TypeOfEdge.hxx>
#endif
class Aspect_EdgeDefinitionError;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class allows the definition of an edge. <br>
class Aspect_Edge  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates an edge. <br>
Standard_EXPORT Aspect_Edge();

//! Creates an edge from an index of vertices <br>
//!	    in a table of vertices. <br>
//!	    <AType> indicates if this edge is seen or not. <br>
//!  Warning: Raises EdgeDefinitionError if AIndex1 == AIndex2. <br>
Standard_EXPORT Aspect_Edge(const Standard_Integer AIndex1,const Standard_Integer AIndex2,const Aspect_TypeOfEdge AType);

//! Updates the values of an edge <me>. <br>
//!  Warning: Raises EdgeDefinitionError if AIndex1 == AIndex2. <br>
Standard_EXPORT   void SetValues(const Standard_Integer AIndex1,const Standard_Integer AIndex2,const Aspect_TypeOfEdge AType) ;

//! Returns the index of the vertices and the <br>
//!	    type of edge <me>. <br>
Standard_EXPORT   void Values(Standard_Integer& AIndex1,Standard_Integer& AIndex2,Aspect_TypeOfEdge& AType) const;

//! Returns the index of the begin of the edge <me>. <br>
Standard_EXPORT   Standard_Integer FirstIndex() const;

//! Returns the index of the end of the edge <me>. <br>
Standard_EXPORT   Standard_Integer LastIndex() const;

//! Returns the type of the edge <me>. <br>
Standard_EXPORT   Aspect_TypeOfEdge Type() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer MyBegin;
Standard_Integer MyEnd;
Aspect_TypeOfEdge MyVisibility;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
