// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Adaptor3d_InterFunc_HeaderFile
#define _Adaptor3d_InterFunc_HeaderFile

#ifndef _Handle_Adaptor2d_HCurve2d_HeaderFile
#include <Handle_Adaptor2d_HCurve2d.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _math_FunctionWithDerivative_HeaderFile
#include <math_FunctionWithDerivative.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Adaptor2d_HCurve2d;
class Standard_ConstructionError;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Used to find the points U(t) = U0 or V(t) = V0 in <br>
//!          order to determine the  Cn discontinuities of  an <br>
//!               Adpator_CurveOnSurface  relativly  to    the <br>
//!          discontinuities of the surface. <br>
class Adaptor3d_InterFunc  : public math_FunctionWithDerivative {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//!   build the function  U(t)=FixVal   if Fix =1 or <br>
//!            V(t)=FixVal if Fix=2 <br>
Standard_EXPORT Adaptor3d_InterFunc(const Handle(Adaptor2d_HCurve2d)& C,const Standard_Real FixVal,const Standard_Integer Fix);

//! computes the value <F>of the function for the variable <X>. <br>
//!         Returns True if the calculation were successfully done, <br>
//!          False otherwise. <br>
Standard_EXPORT   Standard_Boolean Value(const Standard_Real X,Standard_Real& F) ;

//! computes the derivative <D> of the function <br>
//!          for the variable <X>. <br>
//!           Returns True if the calculation were successfully done, <br>
//!           False otherwise. <br>
Standard_EXPORT   Standard_Boolean Derivative(const Standard_Real X,Standard_Real& D) ;

//! computes the value <F> and the derivative <D> of the <br>
//!          function for the variable <X>. <br>
//!          Returns True if the calculation were successfully done, <br>
//!          False otherwise. <br>
Standard_EXPORT   Standard_Boolean Values(const Standard_Real X,Standard_Real& F,Standard_Real& D) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Adaptor2d_HCurve2d myCurve2d;
Standard_Real myFixVal;
Standard_Integer myFix;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
