global env

set env(WOKHOME)     "/usr/share/tcltk/wok2.0"
set env(WOK_LIBRARY) [file join $env(WOKHOME) lib]
set woksite          [file join $env(WOKHOME) site]
set env(WOK_LIBPATH) "$env(WOK_LIBRARY):$woksite:/usr/lib/opencas:/usr/lib"

lappend auto_path $env(WOK_LIBRARY)
package require Wok
package require Ms
package require Tclx

;#
;# Where tcl and edl file of wok reside.
;#

source [file join $env(WOK_LIBRARY) wutils.tcl]
source [file join $env(WOK_LIBRARY) wokprocs.tcl]

;#
;# Where the files ATLIST , DEFAULT.edl and SESSION.edl reside
;#
if {![info exists env(WOK_ROOTADMDIR)] } { 
    set env(WOK_ROOTADMDIR) [file normalize $env(WOKHOME)/wok_entities]
    if ![file exists $env(WOK_ROOTADMDIR)] {
	if [file writable $env(WOKHOME)] {
	    puts stderr "Creating directory $env(WOK_ROOTADMDIR) for wok entities..."
	    if [catch { wokUtils:FILES:mkdir $env(WOK_ROOTADMDIR) } status] {
		puts stderr "Error : $status"
		return
	    }
	    if ![file exists $env(WOK_ROOTADMDIR)] {
		return
	    }
	} else {
	    puts stderr "The directory $env(WOK_ROOTADMDIR) cannot be created because $env(WOKHOME) is not writable."
	    puts stderr "Please give write access to this directory."
	    return
	}
    } else {
	#puts stderr "Using $env(WOKHOME)/wok_entities for working entities."
    }
} else {
    if ![file exists $env(WOK_ROOTADMDIR)] {
	puts stderr "The directory $env(WOK_ROOTADMDIR) can not be found"
	return
    }
    #puts stderr "Using variable WOK_ROOTADMDIR = $env(WOK_ROOTADMDIR) for working entities."    
}

;#
;# Check if  Wok stuff is correct. If not set it up silently.
;#
if ![file exists  [set woksession [file join $env(WOK_ROOTADMDIR) WOKSESSION.edl]]] {
    set str1 [wokUtils:FILES:FileToString [file join $woksite WOKSESSION.edl]]
    regsub -all -- {TOSUBSTITUTE} "$str1" "[file normalize $env(WOK_ROOTADMDIR)]" result1
    wokUtils:FILES:StringToFile $result1 $woksession
    if [file exists $woksession] {
	puts stderr "File $woksession has been created. "
    }
}
;#
;#
;#
if ![file exists [set default [file join $env(WOK_ROOTADMDIR) DEFAULT.edl]]] {
    set str2 [wokUtils:FILES:FileToString [file join $woksite DEFAULT.edl]]
    regsub -all -- {/dp_xx} "$str2" "[file normalize $env(WOK_ROOTADMDIR)]" result2
    wokUtils:FILES:StringToFile $result2 $default
    if [file exists $default] {
	puts stderr "File $default has been created. "
    }
}
;#
;# Where to read/write the current working entity
;#
if {![info exists env(WOK_SESSIONID)] } { 
    set env(WOK_SESSIONID)  $env(HOME)/.wok
}
;#
;# Every thing seems OK. Display a nice prompt:
;#
set tcl_prompt1 {if {[info commands wokcd] != ""}  then \
	{puts -nonewline stdout "[wokcd]> "} else \
	{puts -nonewline stdout "tclsh> "}}
cd $env(WOK_ROOTADMDIR)
wokclose -a
