/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocXml/SchemaTypesXml/DataClassInstanceXml.h"

#include "Doc/SchemaTypesDoc/CDataClassInstanceCollectionDoc.h"
#include "Doc/SchemaTypesDoc/CDataClassInstanceDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/SchemaTypesXml/DataClassInstanceCollectionXml.h"

using namespace Caf;

void DataClassInstanceCollectionXml::add(
	const SmartPtrCDataClassInstanceCollectionDoc dataClassInstanceCollectionDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("DataClassInstanceCollectionXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(dataClassInstanceCollectionDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::deque<SmartPtrCDataClassInstanceDoc> dataClassInstanceVal =
			dataClassInstanceCollectionDoc->getDataClassInstanceCollection();
		CAF_CM_VALIDATE_STL(dataClassInstanceVal);

		if (! dataClassInstanceVal.empty()) {
			for (TConstIterator<std::deque<SmartPtrCDataClassInstanceDoc> > dataClassInstanceIter(dataClassInstanceVal);
				dataClassInstanceIter; dataClassInstanceIter++) {
				const SmartPtrCXmlElement dataClassInstanceXml =
					thisXml->createAndAddElement("dataClassInstance");
				DataClassInstanceXml::add(*dataClassInstanceIter, dataClassInstanceXml);
			}
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCDataClassInstanceCollectionDoc DataClassInstanceCollectionXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("DataClassInstanceCollectionXml", "parse");

	SmartPtrCDataClassInstanceCollectionDoc dataClassInstanceCollectionDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const CXmlElement::SmartPtrCElementCollection dataClassInstanceChildrenXml =
			thisXml->findRequiredChildren("dataClassInstance");

		std::deque<SmartPtrCDataClassInstanceDoc> dataClassInstanceVal;
		if (! dataClassInstanceChildrenXml.IsNull() && ! dataClassInstanceChildrenXml->empty()) {
			for (TConstIterator<CXmlElement::CElementCollection> dataClassInstanceXmlIter(*dataClassInstanceChildrenXml);
				dataClassInstanceXmlIter; dataClassInstanceXmlIter++) {
				const SmartPtrCXmlElement dataClassInstanceXml = dataClassInstanceXmlIter->second;
				const SmartPtrCDataClassInstanceDoc dataClassInstanceDoc =
					DataClassInstanceXml::parse(dataClassInstanceXml);
				dataClassInstanceVal.push_back(dataClassInstanceDoc);
			}
		}

		dataClassInstanceCollectionDoc.CreateInstance();
		dataClassInstanceCollectionDoc->initialize(
			dataClassInstanceVal);
	}
	CAF_CM_EXIT;

	return dataClassInstanceCollectionDoc;
}

