//
// h235.cxx
//
// Code automatically generated by asnparse.
//

#ifdef P_USE_PRAGMA
#pragma implementation "h235.h"
#endif

#include <ptlib.h>
#include "asn/h235.h"

#define new PNEW


#if ! H323_DISABLE_H235

#include "h235_t.cxx"

//
// ChallengeString
//

H235_ChallengeString::H235_ChallengeString(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_OctetString(tag, tagClass)
{
  SetConstraints(PASN_Object::FixedConstraint, 8, 128);
}


H235_ChallengeString::H235_ChallengeString(const char * v)
{
  SetValue(v);
}


H235_ChallengeString::H235_ChallengeString(const PString & v)
{
  SetValue(v);
}


H235_ChallengeString::H235_ChallengeString(const PBYTEArray & v)
{
  SetValue(v);
}


H235_ChallengeString & H235_ChallengeString::operator=(const char * v)
{
  SetValue(v);
  return *this;
}


H235_ChallengeString & H235_ChallengeString::operator=(const PString & v)
{
  SetValue(v);
  return *this;
}


H235_ChallengeString & H235_ChallengeString::operator=(const PBYTEArray & v)
{
  SetValue(v);
  return *this;
}


PObject * H235_ChallengeString::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_ChallengeString::Class()), PInvalidCast);
#endif
  return new H235_ChallengeString(*this);
}


//
// TimeStamp
//

H235_TimeStamp::H235_TimeStamp(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Integer(tag, tagClass)
{
  SetConstraints(PASN_Object::FixedConstraint, 1, 4294967295U);
}


H235_TimeStamp & H235_TimeStamp::operator=(int v)
{
  SetValue(v);
  return *this;
}


H235_TimeStamp & H235_TimeStamp::operator=(unsigned v)
{
  SetValue(v);
  return *this;
}


PObject * H235_TimeStamp::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_TimeStamp::Class()), PInvalidCast);
#endif
  return new H235_TimeStamp(*this);
}


//
// RandomVal
//

H235_RandomVal::H235_RandomVal(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Integer(tag, tagClass)
{
}


H235_RandomVal & H235_RandomVal::operator=(int v)
{
  SetValue(v);
  return *this;
}


H235_RandomVal & H235_RandomVal::operator=(unsigned v)
{
  SetValue(v);
  return *this;
}


PObject * H235_RandomVal::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_RandomVal::Class()), PInvalidCast);
#endif
  return new H235_RandomVal(*this);
}


//
// Password
//

H235_Password::H235_Password(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_BMPString(tag, tagClass)
{
  SetConstraints(PASN_Object::FixedConstraint, 1, 128);
}


H235_Password & H235_Password::operator=(const char * v)
{
  SetValue(v);
  return *this;
}


H235_Password & H235_Password::operator=(const PString & v)
{
  SetValue(v);
  return *this;
}


H235_Password & H235_Password::operator=(const PWORDArray & v)
{
  SetValue(v);
  return *this;
}


H235_Password & H235_Password::operator=(const PASN_BMPString & v)
{
  SetValue(v);
  return *this;
}


PObject * H235_Password::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_Password::Class()), PInvalidCast);
#endif
  return new H235_Password(*this);
}


//
// Identifier
//

H235_Identifier::H235_Identifier(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_BMPString(tag, tagClass)
{
  SetConstraints(PASN_Object::FixedConstraint, 1, 128);
}


H235_Identifier & H235_Identifier::operator=(const char * v)
{
  SetValue(v);
  return *this;
}


H235_Identifier & H235_Identifier::operator=(const PString & v)
{
  SetValue(v);
  return *this;
}


H235_Identifier & H235_Identifier::operator=(const PWORDArray & v)
{
  SetValue(v);
  return *this;
}


H235_Identifier & H235_Identifier::operator=(const PASN_BMPString & v)
{
  SetValue(v);
  return *this;
}


PObject * H235_Identifier::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_Identifier::Class()), PInvalidCast);
#endif
  return new H235_Identifier(*this);
}


//
// KeyMaterial
//

H235_KeyMaterial::H235_KeyMaterial(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_BitString(tag, tagClass)
{
  SetConstraints(PASN_Object::FixedConstraint, 1, 2048);
}


PObject * H235_KeyMaterial::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_KeyMaterial::Class()), PInvalidCast);
#endif
  return new H235_KeyMaterial(*this);
}


//
// NonStandardParameter
//

H235_NonStandardParameter::H235_NonStandardParameter(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, FALSE, 0)
{
}


#ifndef PASN_NOPRINTON
void H235_NonStandardParameter::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+24) << "nonStandardIdentifier = " << setprecision(indent) << m_nonStandardIdentifier << '\n';
  strm << setw(indent+7) << "data = " << setprecision(indent) << m_data << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H235_NonStandardParameter::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H235_NonStandardParameter), PInvalidCast);
#endif
  const H235_NonStandardParameter & other = (const H235_NonStandardParameter &)obj;

  Comparison result;

  if ((result = m_nonStandardIdentifier.Compare(other.m_nonStandardIdentifier)) != EqualTo)
    return result;
  if ((result = m_data.Compare(other.m_data)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H235_NonStandardParameter::GetDataLength() const
{
  PINDEX length = 0;
  length += m_nonStandardIdentifier.GetObjectLength();
  length += m_data.GetObjectLength();
  return length;
}


BOOL H235_NonStandardParameter::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_nonStandardIdentifier.Decode(strm))
    return FALSE;
  if (!m_data.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H235_NonStandardParameter::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_nonStandardIdentifier.Encode(strm);
  m_data.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H235_NonStandardParameter::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_NonStandardParameter::Class()), PInvalidCast);
#endif
  return new H235_NonStandardParameter(*this);
}


//
// DHset
//

H235_DHset::H235_DHset(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, TRUE, 0)
{
  m_halfkey.SetConstraints(PASN_Object::FixedConstraint, 0, 2048);
  m_modSize.SetConstraints(PASN_Object::FixedConstraint, 0, 2048);
  m_generator.SetConstraints(PASN_Object::FixedConstraint, 0, 2048);
}


#ifndef PASN_NOPRINTON
void H235_DHset::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+10) << "halfkey = " << setprecision(indent) << m_halfkey << '\n';
  strm << setw(indent+10) << "modSize = " << setprecision(indent) << m_modSize << '\n';
  strm << setw(indent+12) << "generator = " << setprecision(indent) << m_generator << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H235_DHset::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H235_DHset), PInvalidCast);
#endif
  const H235_DHset & other = (const H235_DHset &)obj;

  Comparison result;

  if ((result = m_halfkey.Compare(other.m_halfkey)) != EqualTo)
    return result;
  if ((result = m_modSize.Compare(other.m_modSize)) != EqualTo)
    return result;
  if ((result = m_generator.Compare(other.m_generator)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H235_DHset::GetDataLength() const
{
  PINDEX length = 0;
  length += m_halfkey.GetObjectLength();
  length += m_modSize.GetObjectLength();
  length += m_generator.GetObjectLength();
  return length;
}


BOOL H235_DHset::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_halfkey.Decode(strm))
    return FALSE;
  if (!m_modSize.Decode(strm))
    return FALSE;
  if (!m_generator.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H235_DHset::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_halfkey.Encode(strm);
  m_modSize.Encode(strm);
  m_generator.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H235_DHset::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_DHset::Class()), PInvalidCast);
#endif
  return new H235_DHset(*this);
}


//
// ECpoint
//

H235_ECpoint::H235_ECpoint(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 2, TRUE, 0)
{
  m_x.SetConstraints(PASN_Object::FixedConstraint, 0, 511);
  m_y.SetConstraints(PASN_Object::FixedConstraint, 0, 511);
}


#ifndef PASN_NOPRINTON
void H235_ECpoint::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  if (HasOptionalField(e_x))
    strm << setw(indent+4) << "x = " << setprecision(indent) << m_x << '\n';
  if (HasOptionalField(e_y))
    strm << setw(indent+4) << "y = " << setprecision(indent) << m_y << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H235_ECpoint::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H235_ECpoint), PInvalidCast);
#endif
  const H235_ECpoint & other = (const H235_ECpoint &)obj;

  Comparison result;

  if ((result = m_x.Compare(other.m_x)) != EqualTo)
    return result;
  if ((result = m_y.Compare(other.m_y)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H235_ECpoint::GetDataLength() const
{
  PINDEX length = 0;
  if (HasOptionalField(e_x))
    length += m_x.GetObjectLength();
  if (HasOptionalField(e_y))
    length += m_y.GetObjectLength();
  return length;
}


BOOL H235_ECpoint::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (HasOptionalField(e_x) && !m_x.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_y) && !m_y.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H235_ECpoint::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  if (HasOptionalField(e_x))
    m_x.Encode(strm);
  if (HasOptionalField(e_y))
    m_y.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H235_ECpoint::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_ECpoint::Class()), PInvalidCast);
#endif
  return new H235_ECpoint(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H235_ECKASDH[]={
      {"eckasdhp",0}
     ,{"eckasdh2",1}
};
#endif
//
// ECKASDH
//

H235_ECKASDH::H235_ECKASDH(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 2, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H235_ECKASDH,2
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H235_ECKASDH::operator H235_ECKASDH_eckasdhp &() const
#else
H235_ECKASDH::operator H235_ECKASDH_eckasdhp &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_ECKASDH_eckasdhp), PInvalidCast);
#endif
  return *(H235_ECKASDH_eckasdhp *)choice;
}


H235_ECKASDH::operator const H235_ECKASDH_eckasdhp &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_ECKASDH_eckasdhp), PInvalidCast);
#endif
  return *(H235_ECKASDH_eckasdhp *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H235_ECKASDH::operator H235_ECKASDH_eckasdh2 &() const
#else
H235_ECKASDH::operator H235_ECKASDH_eckasdh2 &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_ECKASDH_eckasdh2), PInvalidCast);
#endif
  return *(H235_ECKASDH_eckasdh2 *)choice;
}


H235_ECKASDH::operator const H235_ECKASDH_eckasdh2 &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_ECKASDH_eckasdh2), PInvalidCast);
#endif
  return *(H235_ECKASDH_eckasdh2 *)choice;
}


BOOL H235_ECKASDH::CreateObject()
{
  switch (tag) {
    case e_eckasdhp :
      choice = new H235_ECKASDH_eckasdhp();
      return TRUE;
    case e_eckasdh2 :
      choice = new H235_ECKASDH_eckasdh2();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H235_ECKASDH::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_ECKASDH::Class()), PInvalidCast);
#endif
  return new H235_ECKASDH(*this);
}


//
// ECGDSASignature
//

H235_ECGDSASignature::H235_ECGDSASignature(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, FALSE, 0)
{
  m_r.SetConstraints(PASN_Object::FixedConstraint, 0, 511);
  m_s.SetConstraints(PASN_Object::FixedConstraint, 0, 511);
}


#ifndef PASN_NOPRINTON
void H235_ECGDSASignature::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+4) << "r = " << setprecision(indent) << m_r << '\n';
  strm << setw(indent+4) << "s = " << setprecision(indent) << m_s << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H235_ECGDSASignature::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H235_ECGDSASignature), PInvalidCast);
#endif
  const H235_ECGDSASignature & other = (const H235_ECGDSASignature &)obj;

  Comparison result;

  if ((result = m_r.Compare(other.m_r)) != EqualTo)
    return result;
  if ((result = m_s.Compare(other.m_s)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H235_ECGDSASignature::GetDataLength() const
{
  PINDEX length = 0;
  length += m_r.GetObjectLength();
  length += m_s.GetObjectLength();
  return length;
}


BOOL H235_ECGDSASignature::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_r.Decode(strm))
    return FALSE;
  if (!m_s.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H235_ECGDSASignature::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_r.Encode(strm);
  m_s.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H235_ECGDSASignature::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_ECGDSASignature::Class()), PInvalidCast);
#endif
  return new H235_ECGDSASignature(*this);
}


//
// TypedCertificate
//

H235_TypedCertificate::H235_TypedCertificate(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, TRUE, 0)
{
}


#ifndef PASN_NOPRINTON
void H235_TypedCertificate::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+7) << "type = " << setprecision(indent) << m_type << '\n';
  strm << setw(indent+14) << "certificate = " << setprecision(indent) << m_certificate << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H235_TypedCertificate::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H235_TypedCertificate), PInvalidCast);
#endif
  const H235_TypedCertificate & other = (const H235_TypedCertificate &)obj;

  Comparison result;

  if ((result = m_type.Compare(other.m_type)) != EqualTo)
    return result;
  if ((result = m_certificate.Compare(other.m_certificate)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H235_TypedCertificate::GetDataLength() const
{
  PINDEX length = 0;
  length += m_type.GetObjectLength();
  length += m_certificate.GetObjectLength();
  return length;
}


BOOL H235_TypedCertificate::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_type.Decode(strm))
    return FALSE;
  if (!m_certificate.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H235_TypedCertificate::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_type.Encode(strm);
  m_certificate.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H235_TypedCertificate::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_TypedCertificate::Class()), PInvalidCast);
#endif
  return new H235_TypedCertificate(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H235_AuthenticationBES[]={
      {"default",0}
     ,{"radius",1}
};
#endif
//
// AuthenticationBES
//

H235_AuthenticationBES::H235_AuthenticationBES(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 2, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H235_AuthenticationBES,2
#endif
)
{
}


BOOL H235_AuthenticationBES::CreateObject()
{
  choice = (tag <= e_radius) ? new PASN_Null() : NULL;
  return choice != NULL;
}


PObject * H235_AuthenticationBES::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_AuthenticationBES::Class()), PInvalidCast);
#endif
  return new H235_AuthenticationBES(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H235_AuthenticationMechanism[]={
      {"dhExch",0}
     ,{"pwdSymEnc",1}
     ,{"pwdHash",2}
     ,{"certSign",3}
     ,{"ipsec",4}
     ,{"tls",5}
     ,{"nonStandard",6}
     ,{"authenticationBES",7}
};
#endif
//
// AuthenticationMechanism
//

H235_AuthenticationMechanism::H235_AuthenticationMechanism(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 7, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H235_AuthenticationMechanism,8
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H235_AuthenticationMechanism::operator H235_NonStandardParameter &() const
#else
H235_AuthenticationMechanism::operator H235_NonStandardParameter &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_NonStandardParameter), PInvalidCast);
#endif
  return *(H235_NonStandardParameter *)choice;
}


H235_AuthenticationMechanism::operator const H235_NonStandardParameter &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_NonStandardParameter), PInvalidCast);
#endif
  return *(H235_NonStandardParameter *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H235_AuthenticationMechanism::operator H235_AuthenticationBES &() const
#else
H235_AuthenticationMechanism::operator H235_AuthenticationBES &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_AuthenticationBES), PInvalidCast);
#endif
  return *(H235_AuthenticationBES *)choice;
}


H235_AuthenticationMechanism::operator const H235_AuthenticationBES &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_AuthenticationBES), PInvalidCast);
#endif
  return *(H235_AuthenticationBES *)choice;
}


BOOL H235_AuthenticationMechanism::CreateObject()
{
  switch (tag) {
    case e_dhExch :
    case e_pwdSymEnc :
    case e_pwdHash :
    case e_certSign :
    case e_ipsec :
    case e_tls :
      choice = new PASN_Null();
      return TRUE;
    case e_nonStandard :
      choice = new H235_NonStandardParameter();
      return TRUE;
    case e_authenticationBES :
      choice = new H235_AuthenticationBES();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H235_AuthenticationMechanism::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_AuthenticationMechanism::Class()), PInvalidCast);
#endif
  return new H235_AuthenticationMechanism(*this);
}


//
// IV8
//

H235_IV8::H235_IV8(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_OctetString(tag, tagClass)
{
  SetConstraints(PASN_Object::FixedConstraint, 8);
}


H235_IV8::H235_IV8(const char * v)
{
  SetValue(v);
}


H235_IV8::H235_IV8(const PString & v)
{
  SetValue(v);
}


H235_IV8::H235_IV8(const PBYTEArray & v)
{
  SetValue(v);
}


H235_IV8 & H235_IV8::operator=(const char * v)
{
  SetValue(v);
  return *this;
}


H235_IV8 & H235_IV8::operator=(const PString & v)
{
  SetValue(v);
  return *this;
}


H235_IV8 & H235_IV8::operator=(const PBYTEArray & v)
{
  SetValue(v);
  return *this;
}


PObject * H235_IV8::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_IV8::Class()), PInvalidCast);
#endif
  return new H235_IV8(*this);
}


//
// IV16
//

H235_IV16::H235_IV16(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_OctetString(tag, tagClass)
{
  SetConstraints(PASN_Object::FixedConstraint, 16);
}


H235_IV16::H235_IV16(const char * v)
{
  SetValue(v);
}


H235_IV16::H235_IV16(const PString & v)
{
  SetValue(v);
}


H235_IV16::H235_IV16(const PBYTEArray & v)
{
  SetValue(v);
}


H235_IV16 & H235_IV16::operator=(const char * v)
{
  SetValue(v);
  return *this;
}


H235_IV16 & H235_IV16::operator=(const PString & v)
{
  SetValue(v);
  return *this;
}


H235_IV16 & H235_IV16::operator=(const PBYTEArray & v)
{
  SetValue(v);
  return *this;
}


PObject * H235_IV16::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_IV16::Class()), PInvalidCast);
#endif
  return new H235_IV16(*this);
}


//
// Params
//

H235_Params::H235_Params(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 2, TRUE, 3)
{
}


#ifndef PASN_NOPRINTON
void H235_Params::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  if (HasOptionalField(e_ranInt))
    strm << setw(indent+9) << "ranInt = " << setprecision(indent) << m_ranInt << '\n';
  if (HasOptionalField(e_iv8))
    strm << setw(indent+6) << "iv8 = " << setprecision(indent) << m_iv8 << '\n';
  if (HasOptionalField(e_iv16))
    strm << setw(indent+7) << "iv16 = " << setprecision(indent) << m_iv16 << '\n';
  if (HasOptionalField(e_iv))
    strm << setw(indent+5) << "iv = " << setprecision(indent) << m_iv << '\n';
  if (HasOptionalField(e_clearSalt))
    strm << setw(indent+12) << "clearSalt = " << setprecision(indent) << m_clearSalt << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H235_Params::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H235_Params), PInvalidCast);
#endif
  const H235_Params & other = (const H235_Params &)obj;

  Comparison result;

  if ((result = m_ranInt.Compare(other.m_ranInt)) != EqualTo)
    return result;
  if ((result = m_iv8.Compare(other.m_iv8)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H235_Params::GetDataLength() const
{
  PINDEX length = 0;
  if (HasOptionalField(e_ranInt))
    length += m_ranInt.GetObjectLength();
  if (HasOptionalField(e_iv8))
    length += m_iv8.GetObjectLength();
  return length;
}


BOOL H235_Params::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (HasOptionalField(e_ranInt) && !m_ranInt.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_iv8) && !m_iv8.Decode(strm))
    return FALSE;
  if (!KnownExtensionDecode(strm, e_iv16, m_iv16))
    return FALSE;
  if (!KnownExtensionDecode(strm, e_iv, m_iv))
    return FALSE;
  if (!KnownExtensionDecode(strm, e_clearSalt, m_clearSalt))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H235_Params::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  if (HasOptionalField(e_ranInt))
    m_ranInt.Encode(strm);
  if (HasOptionalField(e_iv8))
    m_iv8.Encode(strm);
  KnownExtensionEncode(strm, e_iv16, m_iv16);
  KnownExtensionEncode(strm, e_iv, m_iv);
  KnownExtensionEncode(strm, e_clearSalt, m_clearSalt);

  UnknownExtensionsEncode(strm);
}


PObject * H235_Params::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_Params::Class()), PInvalidCast);
#endif
  return new H235_Params(*this);
}


//
// ReturnSig
//

H235_ReturnSig::H235_ReturnSig(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 2, FALSE, 0)
{
}


#ifndef PASN_NOPRINTON
void H235_ReturnSig::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "generalId = " << setprecision(indent) << m_generalId << '\n';
  strm << setw(indent+17) << "responseRandom = " << setprecision(indent) << m_responseRandom << '\n';
  if (HasOptionalField(e_requestRandom))
    strm << setw(indent+16) << "requestRandom = " << setprecision(indent) << m_requestRandom << '\n';
  if (HasOptionalField(e_certificate))
    strm << setw(indent+14) << "certificate = " << setprecision(indent) << m_certificate << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H235_ReturnSig::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H235_ReturnSig), PInvalidCast);
#endif
  const H235_ReturnSig & other = (const H235_ReturnSig &)obj;

  Comparison result;

  if ((result = m_generalId.Compare(other.m_generalId)) != EqualTo)
    return result;
  if ((result = m_responseRandom.Compare(other.m_responseRandom)) != EqualTo)
    return result;
  if ((result = m_requestRandom.Compare(other.m_requestRandom)) != EqualTo)
    return result;
  if ((result = m_certificate.Compare(other.m_certificate)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H235_ReturnSig::GetDataLength() const
{
  PINDEX length = 0;
  length += m_generalId.GetObjectLength();
  length += m_responseRandom.GetObjectLength();
  if (HasOptionalField(e_requestRandom))
    length += m_requestRandom.GetObjectLength();
  if (HasOptionalField(e_certificate))
    length += m_certificate.GetObjectLength();
  return length;
}


BOOL H235_ReturnSig::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_generalId.Decode(strm))
    return FALSE;
  if (!m_responseRandom.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_requestRandom) && !m_requestRandom.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_certificate) && !m_certificate.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H235_ReturnSig::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_generalId.Encode(strm);
  m_responseRandom.Encode(strm);
  if (HasOptionalField(e_requestRandom))
    m_requestRandom.Encode(strm);
  if (HasOptionalField(e_certificate))
    m_certificate.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H235_ReturnSig::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_ReturnSig::Class()), PInvalidCast);
#endif
  return new H235_ReturnSig(*this);
}


//
// EncodedReturnSig
//

H235_EncodedReturnSig::H235_EncodedReturnSig(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_OctetString(tag, tagClass)
{
}


PObject * H235_EncodedReturnSig::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_EncodedReturnSig::Class()), PInvalidCast);
#endif
  return new H235_EncodedReturnSig(*this);
}


//
// KeySyncMaterial
//

H235_KeySyncMaterial::H235_KeySyncMaterial(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, TRUE, 0)
{
}


#ifndef PASN_NOPRINTON
void H235_KeySyncMaterial::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "generalID = " << setprecision(indent) << m_generalID << '\n';
  strm << setw(indent+14) << "keyMaterial = " << setprecision(indent) << m_keyMaterial << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H235_KeySyncMaterial::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H235_KeySyncMaterial), PInvalidCast);
#endif
  const H235_KeySyncMaterial & other = (const H235_KeySyncMaterial &)obj;

  Comparison result;

  if ((result = m_generalID.Compare(other.m_generalID)) != EqualTo)
    return result;
  if ((result = m_keyMaterial.Compare(other.m_keyMaterial)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H235_KeySyncMaterial::GetDataLength() const
{
  PINDEX length = 0;
  length += m_generalID.GetObjectLength();
  length += m_keyMaterial.GetObjectLength();
  return length;
}


BOOL H235_KeySyncMaterial::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_generalID.Decode(strm))
    return FALSE;
  if (!m_keyMaterial.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H235_KeySyncMaterial::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_generalID.Encode(strm);
  m_keyMaterial.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H235_KeySyncMaterial::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_KeySyncMaterial::Class()), PInvalidCast);
#endif
  return new H235_KeySyncMaterial(*this);
}


//
// EncodedKeySyncMaterial
//

H235_EncodedKeySyncMaterial::H235_EncodedKeySyncMaterial(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_OctetString(tag, tagClass)
{
}


PObject * H235_EncodedKeySyncMaterial::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_EncodedKeySyncMaterial::Class()), PInvalidCast);
#endif
  return new H235_EncodedKeySyncMaterial(*this);
}


//
// V3KeySyncMaterial
//

H235_V3KeySyncMaterial::H235_V3KeySyncMaterial(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 7, TRUE, 0)
{
}


#ifndef PASN_NOPRINTON
void H235_V3KeySyncMaterial::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  if (HasOptionalField(e_generalID))
    strm << setw(indent+12) << "generalID = " << setprecision(indent) << m_generalID << '\n';
  if (HasOptionalField(e_algorithmOID))
    strm << setw(indent+15) << "algorithmOID = " << setprecision(indent) << m_algorithmOID << '\n';
  strm << setw(indent+9) << "paramS = " << setprecision(indent) << m_paramS << '\n';
  if (HasOptionalField(e_encryptedSessionKey))
    strm << setw(indent+22) << "encryptedSessionKey = " << setprecision(indent) << m_encryptedSessionKey << '\n';
  if (HasOptionalField(e_encryptedSaltingKey))
    strm << setw(indent+22) << "encryptedSaltingKey = " << setprecision(indent) << m_encryptedSaltingKey << '\n';
  if (HasOptionalField(e_clearSaltingKey))
    strm << setw(indent+18) << "clearSaltingKey = " << setprecision(indent) << m_clearSaltingKey << '\n';
  if (HasOptionalField(e_paramSsalt))
    strm << setw(indent+13) << "paramSsalt = " << setprecision(indent) << m_paramSsalt << '\n';
  if (HasOptionalField(e_keyDerivationOID))
    strm << setw(indent+19) << "keyDerivationOID = " << setprecision(indent) << m_keyDerivationOID << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H235_V3KeySyncMaterial::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H235_V3KeySyncMaterial), PInvalidCast);
#endif
  const H235_V3KeySyncMaterial & other = (const H235_V3KeySyncMaterial &)obj;

  Comparison result;

  if ((result = m_generalID.Compare(other.m_generalID)) != EqualTo)
    return result;
  if ((result = m_algorithmOID.Compare(other.m_algorithmOID)) != EqualTo)
    return result;
  if ((result = m_paramS.Compare(other.m_paramS)) != EqualTo)
    return result;
  if ((result = m_encryptedSessionKey.Compare(other.m_encryptedSessionKey)) != EqualTo)
    return result;
  if ((result = m_encryptedSaltingKey.Compare(other.m_encryptedSaltingKey)) != EqualTo)
    return result;
  if ((result = m_clearSaltingKey.Compare(other.m_clearSaltingKey)) != EqualTo)
    return result;
  if ((result = m_paramSsalt.Compare(other.m_paramSsalt)) != EqualTo)
    return result;
  if ((result = m_keyDerivationOID.Compare(other.m_keyDerivationOID)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H235_V3KeySyncMaterial::GetDataLength() const
{
  PINDEX length = 0;
  if (HasOptionalField(e_generalID))
    length += m_generalID.GetObjectLength();
  if (HasOptionalField(e_algorithmOID))
    length += m_algorithmOID.GetObjectLength();
  length += m_paramS.GetObjectLength();
  if (HasOptionalField(e_encryptedSessionKey))
    length += m_encryptedSessionKey.GetObjectLength();
  if (HasOptionalField(e_encryptedSaltingKey))
    length += m_encryptedSaltingKey.GetObjectLength();
  if (HasOptionalField(e_clearSaltingKey))
    length += m_clearSaltingKey.GetObjectLength();
  if (HasOptionalField(e_paramSsalt))
    length += m_paramSsalt.GetObjectLength();
  if (HasOptionalField(e_keyDerivationOID))
    length += m_keyDerivationOID.GetObjectLength();
  return length;
}


BOOL H235_V3KeySyncMaterial::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (HasOptionalField(e_generalID) && !m_generalID.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_algorithmOID) && !m_algorithmOID.Decode(strm))
    return FALSE;
  if (!m_paramS.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_encryptedSessionKey) && !m_encryptedSessionKey.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_encryptedSaltingKey) && !m_encryptedSaltingKey.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_clearSaltingKey) && !m_clearSaltingKey.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_paramSsalt) && !m_paramSsalt.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_keyDerivationOID) && !m_keyDerivationOID.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H235_V3KeySyncMaterial::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  if (HasOptionalField(e_generalID))
    m_generalID.Encode(strm);
  if (HasOptionalField(e_algorithmOID))
    m_algorithmOID.Encode(strm);
  m_paramS.Encode(strm);
  if (HasOptionalField(e_encryptedSessionKey))
    m_encryptedSessionKey.Encode(strm);
  if (HasOptionalField(e_encryptedSaltingKey))
    m_encryptedSaltingKey.Encode(strm);
  if (HasOptionalField(e_clearSaltingKey))
    m_clearSaltingKey.Encode(strm);
  if (HasOptionalField(e_paramSsalt))
    m_paramSsalt.Encode(strm);
  if (HasOptionalField(e_keyDerivationOID))
    m_keyDerivationOID.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H235_V3KeySyncMaterial::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_V3KeySyncMaterial::Class()), PInvalidCast);
#endif
  return new H235_V3KeySyncMaterial(*this);
}


//
// ECKASDH_eckasdhp
//

H235_ECKASDH_eckasdhp::H235_ECKASDH_eckasdhp(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, FALSE, 0)
{
  m_modulus.SetConstraints(PASN_Object::FixedConstraint, 0, 511);
  m_weierstrassA.SetConstraints(PASN_Object::FixedConstraint, 0, 511);
  m_weierstrassB.SetConstraints(PASN_Object::FixedConstraint, 0, 511);
}


#ifndef PASN_NOPRINTON
void H235_ECKASDH_eckasdhp::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+13) << "public_key = " << setprecision(indent) << m_public_key << '\n';
  strm << setw(indent+10) << "modulus = " << setprecision(indent) << m_modulus << '\n';
  strm << setw(indent+7) << "base = " << setprecision(indent) << m_base << '\n';
  strm << setw(indent+15) << "weierstrassA = " << setprecision(indent) << m_weierstrassA << '\n';
  strm << setw(indent+15) << "weierstrassB = " << setprecision(indent) << m_weierstrassB << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H235_ECKASDH_eckasdhp::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H235_ECKASDH_eckasdhp), PInvalidCast);
#endif
  const H235_ECKASDH_eckasdhp & other = (const H235_ECKASDH_eckasdhp &)obj;

  Comparison result;

  if ((result = m_public_key.Compare(other.m_public_key)) != EqualTo)
    return result;
  if ((result = m_modulus.Compare(other.m_modulus)) != EqualTo)
    return result;
  if ((result = m_base.Compare(other.m_base)) != EqualTo)
    return result;
  if ((result = m_weierstrassA.Compare(other.m_weierstrassA)) != EqualTo)
    return result;
  if ((result = m_weierstrassB.Compare(other.m_weierstrassB)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H235_ECKASDH_eckasdhp::GetDataLength() const
{
  PINDEX length = 0;
  length += m_public_key.GetObjectLength();
  length += m_modulus.GetObjectLength();
  length += m_base.GetObjectLength();
  length += m_weierstrassA.GetObjectLength();
  length += m_weierstrassB.GetObjectLength();
  return length;
}


BOOL H235_ECKASDH_eckasdhp::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_public_key.Decode(strm))
    return FALSE;
  if (!m_modulus.Decode(strm))
    return FALSE;
  if (!m_base.Decode(strm))
    return FALSE;
  if (!m_weierstrassA.Decode(strm))
    return FALSE;
  if (!m_weierstrassB.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H235_ECKASDH_eckasdhp::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_public_key.Encode(strm);
  m_modulus.Encode(strm);
  m_base.Encode(strm);
  m_weierstrassA.Encode(strm);
  m_weierstrassB.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H235_ECKASDH_eckasdhp::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_ECKASDH_eckasdhp::Class()), PInvalidCast);
#endif
  return new H235_ECKASDH_eckasdhp(*this);
}


//
// ECKASDH_eckasdh2
//

H235_ECKASDH_eckasdh2::H235_ECKASDH_eckasdh2(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, FALSE, 0)
{
  m_fieldSize.SetConstraints(PASN_Object::FixedConstraint, 0, 511);
  m_weierstrassA.SetConstraints(PASN_Object::FixedConstraint, 0, 511);
  m_weierstrassB.SetConstraints(PASN_Object::FixedConstraint, 0, 511);
}


#ifndef PASN_NOPRINTON
void H235_ECKASDH_eckasdh2::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+13) << "public_key = " << setprecision(indent) << m_public_key << '\n';
  strm << setw(indent+12) << "fieldSize = " << setprecision(indent) << m_fieldSize << '\n';
  strm << setw(indent+7) << "base = " << setprecision(indent) << m_base << '\n';
  strm << setw(indent+15) << "weierstrassA = " << setprecision(indent) << m_weierstrassA << '\n';
  strm << setw(indent+15) << "weierstrassB = " << setprecision(indent) << m_weierstrassB << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H235_ECKASDH_eckasdh2::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H235_ECKASDH_eckasdh2), PInvalidCast);
#endif
  const H235_ECKASDH_eckasdh2 & other = (const H235_ECKASDH_eckasdh2 &)obj;

  Comparison result;

  if ((result = m_public_key.Compare(other.m_public_key)) != EqualTo)
    return result;
  if ((result = m_fieldSize.Compare(other.m_fieldSize)) != EqualTo)
    return result;
  if ((result = m_base.Compare(other.m_base)) != EqualTo)
    return result;
  if ((result = m_weierstrassA.Compare(other.m_weierstrassA)) != EqualTo)
    return result;
  if ((result = m_weierstrassB.Compare(other.m_weierstrassB)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H235_ECKASDH_eckasdh2::GetDataLength() const
{
  PINDEX length = 0;
  length += m_public_key.GetObjectLength();
  length += m_fieldSize.GetObjectLength();
  length += m_base.GetObjectLength();
  length += m_weierstrassA.GetObjectLength();
  length += m_weierstrassB.GetObjectLength();
  return length;
}


BOOL H235_ECKASDH_eckasdh2::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_public_key.Decode(strm))
    return FALSE;
  if (!m_fieldSize.Decode(strm))
    return FALSE;
  if (!m_base.Decode(strm))
    return FALSE;
  if (!m_weierstrassA.Decode(strm))
    return FALSE;
  if (!m_weierstrassB.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H235_ECKASDH_eckasdh2::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_public_key.Encode(strm);
  m_fieldSize.Encode(strm);
  m_base.Encode(strm);
  m_weierstrassA.Encode(strm);
  m_weierstrassB.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H235_ECKASDH_eckasdh2::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_ECKASDH_eckasdh2::Class()), PInvalidCast);
#endif
  return new H235_ECKASDH_eckasdh2(*this);
}


//
// KeySignedMaterial
//

H235_KeySignedMaterial::H235_KeySignedMaterial(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 2, FALSE, 0)
{
}


#ifndef PASN_NOPRINTON
void H235_KeySignedMaterial::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "generalId = " << setprecision(indent) << m_generalId << '\n';
  strm << setw(indent+10) << "mrandom = " << setprecision(indent) << m_mrandom << '\n';
  if (HasOptionalField(e_srandom))
    strm << setw(indent+10) << "srandom = " << setprecision(indent) << m_srandom << '\n';
  if (HasOptionalField(e_timeStamp))
    strm << setw(indent+12) << "timeStamp = " << setprecision(indent) << m_timeStamp << '\n';
  strm << setw(indent+12) << "encrptval = " << setprecision(indent) << m_encrptval << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H235_KeySignedMaterial::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H235_KeySignedMaterial), PInvalidCast);
#endif
  const H235_KeySignedMaterial & other = (const H235_KeySignedMaterial &)obj;

  Comparison result;

  if ((result = m_generalId.Compare(other.m_generalId)) != EqualTo)
    return result;
  if ((result = m_mrandom.Compare(other.m_mrandom)) != EqualTo)
    return result;
  if ((result = m_srandom.Compare(other.m_srandom)) != EqualTo)
    return result;
  if ((result = m_timeStamp.Compare(other.m_timeStamp)) != EqualTo)
    return result;
  if ((result = m_encrptval.Compare(other.m_encrptval)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H235_KeySignedMaterial::GetDataLength() const
{
  PINDEX length = 0;
  length += m_generalId.GetObjectLength();
  length += m_mrandom.GetObjectLength();
  if (HasOptionalField(e_srandom))
    length += m_srandom.GetObjectLength();
  if (HasOptionalField(e_timeStamp))
    length += m_timeStamp.GetObjectLength();
  length += m_encrptval.GetObjectLength();
  return length;
}


BOOL H235_KeySignedMaterial::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_generalId.Decode(strm))
    return FALSE;
  if (!m_mrandom.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_srandom) && !m_srandom.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_timeStamp) && !m_timeStamp.Decode(strm))
    return FALSE;
  if (!m_encrptval.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H235_KeySignedMaterial::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_generalId.Encode(strm);
  m_mrandom.Encode(strm);
  if (HasOptionalField(e_srandom))
    m_srandom.Encode(strm);
  if (HasOptionalField(e_timeStamp))
    m_timeStamp.Encode(strm);
  m_encrptval.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H235_KeySignedMaterial::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_KeySignedMaterial::Class()), PInvalidCast);
#endif
  return new H235_KeySignedMaterial(*this);
}


//
// EncodedKeySignedMaterial
//

H235_EncodedKeySignedMaterial::H235_EncodedKeySignedMaterial(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_OctetString(tag, tagClass)
{
}


PObject * H235_EncodedKeySignedMaterial::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_EncodedKeySignedMaterial::Class()), PInvalidCast);
#endif
  return new H235_EncodedKeySignedMaterial(*this);
}


//
// H235CertificateSignature
//

H235_H235CertificateSignature::H235_H235CertificateSignature(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 1, TRUE, 0)
{
}


#ifndef PASN_NOPRINTON
void H235_H235CertificateSignature::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+14) << "certificate = " << setprecision(indent) << m_certificate << '\n';
  strm << setw(indent+17) << "responseRandom = " << setprecision(indent) << m_responseRandom << '\n';
  if (HasOptionalField(e_requesterRandom))
    strm << setw(indent+18) << "requesterRandom = " << setprecision(indent) << m_requesterRandom << '\n';
  strm << setw(indent+12) << "signature = " << setprecision(indent) << m_signature << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H235_H235CertificateSignature::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H235_H235CertificateSignature), PInvalidCast);
#endif
  const H235_H235CertificateSignature & other = (const H235_H235CertificateSignature &)obj;

  Comparison result;

  if ((result = m_certificate.Compare(other.m_certificate)) != EqualTo)
    return result;
  if ((result = m_responseRandom.Compare(other.m_responseRandom)) != EqualTo)
    return result;
  if ((result = m_requesterRandom.Compare(other.m_requesterRandom)) != EqualTo)
    return result;
  if ((result = m_signature.Compare(other.m_signature)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H235_H235CertificateSignature::GetDataLength() const
{
  PINDEX length = 0;
  length += m_certificate.GetObjectLength();
  length += m_responseRandom.GetObjectLength();
  if (HasOptionalField(e_requesterRandom))
    length += m_requesterRandom.GetObjectLength();
  length += m_signature.GetObjectLength();
  return length;
}


BOOL H235_H235CertificateSignature::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_certificate.Decode(strm))
    return FALSE;
  if (!m_responseRandom.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_requesterRandom) && !m_requesterRandom.Decode(strm))
    return FALSE;
  if (!m_signature.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H235_H235CertificateSignature::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_certificate.Encode(strm);
  m_responseRandom.Encode(strm);
  if (HasOptionalField(e_requesterRandom))
    m_requesterRandom.Encode(strm);
  m_signature.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H235_H235CertificateSignature::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_H235CertificateSignature::Class()), PInvalidCast);
#endif
  return new H235_H235CertificateSignature(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H235_H235Key[]={
      {"secureChannel",0}
     ,{"sharedSecret",1}
     ,{"certProtectedKey",2}
     ,{"secureSharedSecret",3}
};
#endif
//
// H235Key
//

H235_H235Key::H235_H235Key(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 3, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H235_H235Key,4
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H235_H235Key::operator H235_KeyMaterial &() const
#else
H235_H235Key::operator H235_KeyMaterial &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_KeyMaterial), PInvalidCast);
#endif
  return *(H235_KeyMaterial *)choice;
}


H235_H235Key::operator const H235_KeyMaterial &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_KeyMaterial), PInvalidCast);
#endif
  return *(H235_KeyMaterial *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H235_H235Key::operator H235_ENCRYPTED<H235_EncodedKeySyncMaterial> &() const
#else
H235_H235Key::operator H235_ENCRYPTED<H235_EncodedKeySyncMaterial> &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_ENCRYPTED<H235_EncodedKeySyncMaterial>), PInvalidCast);
#endif
  return *(H235_ENCRYPTED<H235_EncodedKeySyncMaterial> *)choice;
}


H235_H235Key::operator const H235_ENCRYPTED<H235_EncodedKeySyncMaterial> &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_ENCRYPTED<H235_EncodedKeySyncMaterial>), PInvalidCast);
#endif
  return *(H235_ENCRYPTED<H235_EncodedKeySyncMaterial> *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H235_H235Key::operator H235_SIGNED<H235_EncodedKeySignedMaterial> &() const
#else
H235_H235Key::operator H235_SIGNED<H235_EncodedKeySignedMaterial> &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_SIGNED<H235_EncodedKeySignedMaterial>), PInvalidCast);
#endif
  return *(H235_SIGNED<H235_EncodedKeySignedMaterial> *)choice;
}


H235_H235Key::operator const H235_SIGNED<H235_EncodedKeySignedMaterial> &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_SIGNED<H235_EncodedKeySignedMaterial>), PInvalidCast);
#endif
  return *(H235_SIGNED<H235_EncodedKeySignedMaterial> *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H235_H235Key::operator H235_V3KeySyncMaterial &() const
#else
H235_H235Key::operator H235_V3KeySyncMaterial &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_V3KeySyncMaterial), PInvalidCast);
#endif
  return *(H235_V3KeySyncMaterial *)choice;
}


H235_H235Key::operator const H235_V3KeySyncMaterial &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_V3KeySyncMaterial), PInvalidCast);
#endif
  return *(H235_V3KeySyncMaterial *)choice;
}


BOOL H235_H235Key::CreateObject()
{
  switch (tag) {
    case e_secureChannel :
      choice = new H235_KeyMaterial();
      return TRUE;
    case e_sharedSecret :
      choice = new H235_ENCRYPTED<H235_EncodedKeySyncMaterial>();
      return TRUE;
    case e_certProtectedKey :
      choice = new H235_SIGNED<H235_EncodedKeySignedMaterial>();
      return TRUE;
    case e_secureSharedSecret :
      choice = new H235_V3KeySyncMaterial();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H235_H235Key::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_H235Key::Class()), PInvalidCast);
#endif
  return new H235_H235Key(*this);
}


//
// ClearToken
//

H235_ClearToken::H235_ClearToken(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 8, TRUE, 3)
{
}


#ifndef PASN_NOPRINTON
void H235_ClearToken::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+11) << "tokenOID = " << setprecision(indent) << m_tokenOID << '\n';
  if (HasOptionalField(e_timeStamp))
    strm << setw(indent+12) << "timeStamp = " << setprecision(indent) << m_timeStamp << '\n';
  if (HasOptionalField(e_password))
    strm << setw(indent+11) << "password = " << setprecision(indent) << m_password << '\n';
  if (HasOptionalField(e_dhkey))
    strm << setw(indent+8) << "dhkey = " << setprecision(indent) << m_dhkey << '\n';
  if (HasOptionalField(e_challenge))
    strm << setw(indent+12) << "challenge = " << setprecision(indent) << m_challenge << '\n';
  if (HasOptionalField(e_random))
    strm << setw(indent+9) << "random = " << setprecision(indent) << m_random << '\n';
  if (HasOptionalField(e_certificate))
    strm << setw(indent+14) << "certificate = " << setprecision(indent) << m_certificate << '\n';
  if (HasOptionalField(e_generalID))
    strm << setw(indent+12) << "generalID = " << setprecision(indent) << m_generalID << '\n';
  if (HasOptionalField(e_nonStandard))
    strm << setw(indent+14) << "nonStandard = " << setprecision(indent) << m_nonStandard << '\n';
  if (HasOptionalField(e_eckasdhkey))
    strm << setw(indent+13) << "eckasdhkey = " << setprecision(indent) << m_eckasdhkey << '\n';
  if (HasOptionalField(e_sendersID))
    strm << setw(indent+12) << "sendersID = " << setprecision(indent) << m_sendersID << '\n';
  if (HasOptionalField(e_h235Key))
    strm << setw(indent+10) << "h235Key = " << setprecision(indent) << m_h235Key << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H235_ClearToken::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H235_ClearToken), PInvalidCast);
#endif
  const H235_ClearToken & other = (const H235_ClearToken &)obj;

  Comparison result;

  if ((result = m_tokenOID.Compare(other.m_tokenOID)) != EqualTo)
    return result;
  if ((result = m_timeStamp.Compare(other.m_timeStamp)) != EqualTo)
    return result;
  if ((result = m_password.Compare(other.m_password)) != EqualTo)
    return result;
  if ((result = m_dhkey.Compare(other.m_dhkey)) != EqualTo)
    return result;
  if ((result = m_challenge.Compare(other.m_challenge)) != EqualTo)
    return result;
  if ((result = m_random.Compare(other.m_random)) != EqualTo)
    return result;
  if ((result = m_certificate.Compare(other.m_certificate)) != EqualTo)
    return result;
  if ((result = m_generalID.Compare(other.m_generalID)) != EqualTo)
    return result;
  if ((result = m_nonStandard.Compare(other.m_nonStandard)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H235_ClearToken::GetDataLength() const
{
  PINDEX length = 0;
  length += m_tokenOID.GetObjectLength();
  if (HasOptionalField(e_timeStamp))
    length += m_timeStamp.GetObjectLength();
  if (HasOptionalField(e_password))
    length += m_password.GetObjectLength();
  if (HasOptionalField(e_dhkey))
    length += m_dhkey.GetObjectLength();
  if (HasOptionalField(e_challenge))
    length += m_challenge.GetObjectLength();
  if (HasOptionalField(e_random))
    length += m_random.GetObjectLength();
  if (HasOptionalField(e_certificate))
    length += m_certificate.GetObjectLength();
  if (HasOptionalField(e_generalID))
    length += m_generalID.GetObjectLength();
  if (HasOptionalField(e_nonStandard))
    length += m_nonStandard.GetObjectLength();
  return length;
}


BOOL H235_ClearToken::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_tokenOID.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_timeStamp) && !m_timeStamp.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_password) && !m_password.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_dhkey) && !m_dhkey.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_challenge) && !m_challenge.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_random) && !m_random.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_certificate) && !m_certificate.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_generalID) && !m_generalID.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_nonStandard) && !m_nonStandard.Decode(strm))
    return FALSE;
  if (!KnownExtensionDecode(strm, e_eckasdhkey, m_eckasdhkey))
    return FALSE;
  if (!KnownExtensionDecode(strm, e_sendersID, m_sendersID))
    return FALSE;
  if (!KnownExtensionDecode(strm, e_h235Key, m_h235Key))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H235_ClearToken::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_tokenOID.Encode(strm);
  if (HasOptionalField(e_timeStamp))
    m_timeStamp.Encode(strm);
  if (HasOptionalField(e_password))
    m_password.Encode(strm);
  if (HasOptionalField(e_dhkey))
    m_dhkey.Encode(strm);
  if (HasOptionalField(e_challenge))
    m_challenge.Encode(strm);
  if (HasOptionalField(e_random))
    m_random.Encode(strm);
  if (HasOptionalField(e_certificate))
    m_certificate.Encode(strm);
  if (HasOptionalField(e_generalID))
    m_generalID.Encode(strm);
  if (HasOptionalField(e_nonStandard))
    m_nonStandard.Encode(strm);
  KnownExtensionEncode(strm, e_eckasdhkey, m_eckasdhkey);
  KnownExtensionEncode(strm, e_sendersID, m_sendersID);
  KnownExtensionEncode(strm, e_h235Key, m_h235Key);

  UnknownExtensionsEncode(strm);
}


PObject * H235_ClearToken::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_ClearToken::Class()), PInvalidCast);
#endif
  return new H235_ClearToken(*this);
}


//
// EncodedGeneralToken
//

H235_EncodedGeneralToken::H235_EncodedGeneralToken(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_OctetString(tag, tagClass)
{
}


PObject * H235_EncodedGeneralToken::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_EncodedGeneralToken::Class()), PInvalidCast);
#endif
  return new H235_EncodedGeneralToken(*this);
}


//
// PwdCertToken
//

H235_PwdCertToken::H235_PwdCertToken(unsigned tag, PASN_Object::TagClass tagClass)
  : H235_ClearToken(tag, tagClass)
{
  IncludeOptionalField(e_generalID);
  IncludeOptionalField(e_timeStamp);
}


PObject * H235_PwdCertToken::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_PwdCertToken::Class()), PInvalidCast);
#endif
  return new H235_PwdCertToken(*this);
}


//
// EncodedPwdCertToken
//

H235_EncodedPwdCertToken::H235_EncodedPwdCertToken(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_OctetString(tag, tagClass)
{
}


PObject * H235_EncodedPwdCertToken::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_EncodedPwdCertToken::Class()), PInvalidCast);
#endif
  return new H235_EncodedPwdCertToken(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H235_CryptoToken[]={
      {"cryptoEncryptedToken",0}
     ,{"cryptoSignedToken",1}
     ,{"cryptoHashedToken",2}
     ,{"cryptoPwdEncr",3}
};
#endif
//
// CryptoToken
//

H235_CryptoToken::H235_CryptoToken(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 4, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H235_CryptoToken,4
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H235_CryptoToken::operator H235_CryptoToken_cryptoEncryptedToken &() const
#else
H235_CryptoToken::operator H235_CryptoToken_cryptoEncryptedToken &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_CryptoToken_cryptoEncryptedToken), PInvalidCast);
#endif
  return *(H235_CryptoToken_cryptoEncryptedToken *)choice;
}


H235_CryptoToken::operator const H235_CryptoToken_cryptoEncryptedToken &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_CryptoToken_cryptoEncryptedToken), PInvalidCast);
#endif
  return *(H235_CryptoToken_cryptoEncryptedToken *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H235_CryptoToken::operator H235_CryptoToken_cryptoSignedToken &() const
#else
H235_CryptoToken::operator H235_CryptoToken_cryptoSignedToken &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_CryptoToken_cryptoSignedToken), PInvalidCast);
#endif
  return *(H235_CryptoToken_cryptoSignedToken *)choice;
}


H235_CryptoToken::operator const H235_CryptoToken_cryptoSignedToken &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_CryptoToken_cryptoSignedToken), PInvalidCast);
#endif
  return *(H235_CryptoToken_cryptoSignedToken *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H235_CryptoToken::operator H235_CryptoToken_cryptoHashedToken &() const
#else
H235_CryptoToken::operator H235_CryptoToken_cryptoHashedToken &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_CryptoToken_cryptoHashedToken), PInvalidCast);
#endif
  return *(H235_CryptoToken_cryptoHashedToken *)choice;
}


H235_CryptoToken::operator const H235_CryptoToken_cryptoHashedToken &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_CryptoToken_cryptoHashedToken), PInvalidCast);
#endif
  return *(H235_CryptoToken_cryptoHashedToken *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H235_CryptoToken::operator H235_ENCRYPTED<H235_EncodedPwdCertToken> &() const
#else
H235_CryptoToken::operator H235_ENCRYPTED<H235_EncodedPwdCertToken> &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_ENCRYPTED<H235_EncodedPwdCertToken>), PInvalidCast);
#endif
  return *(H235_ENCRYPTED<H235_EncodedPwdCertToken> *)choice;
}


H235_CryptoToken::operator const H235_ENCRYPTED<H235_EncodedPwdCertToken> &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_ENCRYPTED<H235_EncodedPwdCertToken>), PInvalidCast);
#endif
  return *(H235_ENCRYPTED<H235_EncodedPwdCertToken> *)choice;
}


BOOL H235_CryptoToken::CreateObject()
{
  switch (tag) {
    case e_cryptoEncryptedToken :
      choice = new H235_CryptoToken_cryptoEncryptedToken();
      return TRUE;
    case e_cryptoSignedToken :
      choice = new H235_CryptoToken_cryptoSignedToken();
      return TRUE;
    case e_cryptoHashedToken :
      choice = new H235_CryptoToken_cryptoHashedToken();
      return TRUE;
    case e_cryptoPwdEncr :
      choice = new H235_ENCRYPTED<H235_EncodedPwdCertToken>();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H235_CryptoToken::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_CryptoToken::Class()), PInvalidCast);
#endif
  return new H235_CryptoToken(*this);
}


//
// CryptoToken_cryptoEncryptedToken
//

H235_CryptoToken_cryptoEncryptedToken::H235_CryptoToken_cryptoEncryptedToken(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, FALSE, 0)
{
}


#ifndef PASN_NOPRINTON
void H235_CryptoToken_cryptoEncryptedToken::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+11) << "tokenOID = " << setprecision(indent) << m_tokenOID << '\n';
  strm << setw(indent+8) << "token = " << setprecision(indent) << m_token << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H235_CryptoToken_cryptoEncryptedToken::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H235_CryptoToken_cryptoEncryptedToken), PInvalidCast);
#endif
  const H235_CryptoToken_cryptoEncryptedToken & other = (const H235_CryptoToken_cryptoEncryptedToken &)obj;

  Comparison result;

  if ((result = m_tokenOID.Compare(other.m_tokenOID)) != EqualTo)
    return result;
  if ((result = m_token.Compare(other.m_token)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H235_CryptoToken_cryptoEncryptedToken::GetDataLength() const
{
  PINDEX length = 0;
  length += m_tokenOID.GetObjectLength();
  length += m_token.GetObjectLength();
  return length;
}


BOOL H235_CryptoToken_cryptoEncryptedToken::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_tokenOID.Decode(strm))
    return FALSE;
  if (!m_token.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H235_CryptoToken_cryptoEncryptedToken::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_tokenOID.Encode(strm);
  m_token.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H235_CryptoToken_cryptoEncryptedToken::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_CryptoToken_cryptoEncryptedToken::Class()), PInvalidCast);
#endif
  return new H235_CryptoToken_cryptoEncryptedToken(*this);
}


//
// CryptoToken_cryptoSignedToken
//

H235_CryptoToken_cryptoSignedToken::H235_CryptoToken_cryptoSignedToken(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, FALSE, 0)
{
}


#ifndef PASN_NOPRINTON
void H235_CryptoToken_cryptoSignedToken::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+11) << "tokenOID = " << setprecision(indent) << m_tokenOID << '\n';
  strm << setw(indent+8) << "token = " << setprecision(indent) << m_token << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H235_CryptoToken_cryptoSignedToken::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H235_CryptoToken_cryptoSignedToken), PInvalidCast);
#endif
  const H235_CryptoToken_cryptoSignedToken & other = (const H235_CryptoToken_cryptoSignedToken &)obj;

  Comparison result;

  if ((result = m_tokenOID.Compare(other.m_tokenOID)) != EqualTo)
    return result;
  if ((result = m_token.Compare(other.m_token)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H235_CryptoToken_cryptoSignedToken::GetDataLength() const
{
  PINDEX length = 0;
  length += m_tokenOID.GetObjectLength();
  length += m_token.GetObjectLength();
  return length;
}


BOOL H235_CryptoToken_cryptoSignedToken::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_tokenOID.Decode(strm))
    return FALSE;
  if (!m_token.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H235_CryptoToken_cryptoSignedToken::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_tokenOID.Encode(strm);
  m_token.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H235_CryptoToken_cryptoSignedToken::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_CryptoToken_cryptoSignedToken::Class()), PInvalidCast);
#endif
  return new H235_CryptoToken_cryptoSignedToken(*this);
}


//
// CryptoToken_cryptoHashedToken
//

H235_CryptoToken_cryptoHashedToken::H235_CryptoToken_cryptoHashedToken(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, FALSE, 0)
{
}


#ifndef PASN_NOPRINTON
void H235_CryptoToken_cryptoHashedToken::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+11) << "tokenOID = " << setprecision(indent) << m_tokenOID << '\n';
  strm << setw(indent+13) << "hashedVals = " << setprecision(indent) << m_hashedVals << '\n';
  strm << setw(indent+8) << "token = " << setprecision(indent) << m_token << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H235_CryptoToken_cryptoHashedToken::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H235_CryptoToken_cryptoHashedToken), PInvalidCast);
#endif
  const H235_CryptoToken_cryptoHashedToken & other = (const H235_CryptoToken_cryptoHashedToken &)obj;

  Comparison result;

  if ((result = m_tokenOID.Compare(other.m_tokenOID)) != EqualTo)
    return result;
  if ((result = m_hashedVals.Compare(other.m_hashedVals)) != EqualTo)
    return result;
  if ((result = m_token.Compare(other.m_token)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H235_CryptoToken_cryptoHashedToken::GetDataLength() const
{
  PINDEX length = 0;
  length += m_tokenOID.GetObjectLength();
  length += m_hashedVals.GetObjectLength();
  length += m_token.GetObjectLength();
  return length;
}


BOOL H235_CryptoToken_cryptoHashedToken::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_tokenOID.Decode(strm))
    return FALSE;
  if (!m_hashedVals.Decode(strm))
    return FALSE;
  if (!m_token.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H235_CryptoToken_cryptoHashedToken::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_tokenOID.Encode(strm);
  m_hashedVals.Encode(strm);
  m_token.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H235_CryptoToken_cryptoHashedToken::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H235_CryptoToken_cryptoHashedToken::Class()), PInvalidCast);
#endif
  return new H235_CryptoToken_cryptoHashedToken(*this);
}


#endif // if ! H323_DISABLE_H235


// End of h235.cxx
