/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef TUNING_H
#define TUNING_H

namespace Om {
	
	
static const size_t event_queue_size      = 512;
static const size_t slow_event_queue_size = 512;

static const size_t   post_processor_queue_size = 512;
static const timespec post_processor_rate       = { 0, 125000000 }; // 1/8 s

static const size_t   maid_queue_size = 1024;
static const timespec maid_rate       = { 0, 500000000 }; // 1/2 second


} // namespace Om

#endif // TUNING_H
