/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef REQUESTMETADATAEVENT_H
#define REQUESTMETADATAEVENT_H

#include <lo/lo.h>
#include <string>
#include "SlowEvent.h"
#include "List.h"

using std::string;

namespace Om {
	
class OmObject;
class RequestMetadata;


/** A request from a client for a piece of metadata.
 *
 * \ingroup engine
 */
class RequestMetadataEvent : public SlowEvent
{
public:
	RequestMetadataEvent(Request* request, const string& url, const string& path, const string& key);
	virtual ~RequestMetadataEvent();

	void prepare();
	void execute(uint sample_offset);
	void post_process();

private:
	string     m_url;
	lo_address m_addr;
	string     m_path;
	string     m_key;
	string     m_value;
	OmObject*  m_object;
};


} // namespace Om

#endif // REQUESTMETADATAEVENT_H
